<?php


namespace Mainto\MRPC\Server;


use BadMethodCallException;
use Mainto\MRPC\Protocol\Request\Request;
use Mainto\MRPC\Service\RpcParameter;
use Mainto\MRPC\Service\RpcRouter;
use ReflectionMethod;

class RpcInvoke {
    /**
     * @var Request
     */
    private Request $request;

    public function __construct (Request $request) {

        $this->request = $request;
    }

    public function invoke() {
        $classInstancesMap = RpcRouter::getInstance()->getClassInstancesMap();
        if (!$classItem = ($classInstancesMap[$this->request->getCallClassName()] ?? null)) {
            throw new BadMethodCallException();
        }

        if (!$methodItem = ($classItem['methodItems'][$this->request->getCallMethodName()] ?? null)) {
            throw new BadMethodCallException();
        }
        $classObj = $classItem['classInstance'];

        /** @var ReflectionMethod $methodInstance */
        /** @var RpcParameter $parameter */
        ['methodInstance' => $methodInstance, 'parameter' => $parameter] = $methodItem;

        $rpcParams = new RpcParams($parameter, $this->request->getBody()->toCollection());

        $context = new RpcContext($rpcParams);

        return $methodInstance->invokeArgs($classObj, $rpcParams->buildMethodParam($context));
    }
}