plugins {
    id 'org.jetbrains.kotlin.jvm' version '1.5.10'
    id 'java'
    id 'maven-publish'
}

group '{{$group}}'
version '{{$version}}'

static def valueIf(value, defaultValue) {
    if (value) {
        return value
    }

    return defaultValue
}

repositories {
    mavenCentral()
}

java {
    withSourcesJar()
    withJavadocJar()
}

publishing {
    repositories {
        maven {
            if (project.version.toString().endsWith("-SNAPSHOT")) {
                name = "snapshotsRepo"
                url = uri(valueIf(System.getenv('NEXUS_SNAPSHOTS_URL'), "https://org.default.com"))
            } else {
                name = "releasesRepo"
                url = uri(valueIf(System.getenv('NEXUS_RELEASE_URL'), "https://org.default.com"))
            }
            println "verison=${project.version}"
            println "url=${url}"
            credentials {
                username = System.getenv('NEXUS_USERNAME')
                password = System.getenv('NEXUS_PASSWORD')
            }

        }
    }
    publications {
        maven(MavenPublication) {
            group = project.group
            version = project.version.toString()
            artifactId = project.name
            from(components["java"])
        }
    }
}

repositories {
    mavenCentral()

    maven {
        url = "https://nexus.code.hzmantu.com/repository/java-release/"
        credentials {
            username = 'mainto-tech'
            password = 'o6OBGdnmYEufCX0h'
        }
    }
}

dependencies {
    implementation "org.jetbrains.kotlin:kotlin-stdlib"
    implementation "com.mainto.java-rpc-framework:rpc-client:1.0.7"
    implementation 'org.slf4j:slf4j-log4j12:1.7.32'
}
