<?php
/**
 * Created by PhpStorm.
 * User: liuzaisen
 * Date: 2018/10/18
 * Time: 8:09 PM
 */

namespace Mainto\RpcTool\Command;


use Exception;
use Illuminate\Console\Command;

class RpcDocClean extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:doc_clean {--file_path=} {--controller_dir=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'clean document cache';

    /**
     * Execute the console command.
     *
     * @return mixed
     * @throws Exception
     */
    public function handle () {
        if (!$file_path = $this->option('file_path')) {
            $file_path = config('rpc-tool.micro_doc.doc_dir').'/definition.json';
        }
        $this->cleanFile($file_path);

        if (!$dir_path = $this->option('controller_dir')) {
            $dir_path = config('rpc-tool.micro_doc.doc_dir').'controllers';
        }
        $this->cleanDir($dir_path);

        $this->comment("no cache file need to clean");
    }

    /**
     * @param $file
     * @return string
     * @throws Exception
     */
    public function getNamespace ($file) {
        $fp = fopen($file, 'r');
        while ($line = fgets($fp)) {
            if (strpos($line, 'namespace') !== false) {
                fclose($fp);
                return trim(str_replace(['namespace', ';'], '', $line));
            }
        }
        fclose($fp);
        throw new Exception('not found namespace!');
    }

    /**
     * @param $file_path
     */
    public function cleanFile ($file_path) {
        if (file_exists($file_path)) {
            if (unlink($file_path)) {
                $this->comment("clean success");
            } else {
                $this->comment("clean fail!");
                exit(1);
            }

            return;
        }
    }

    /**
     * @param $dir_path
     */
    public function cleanDir ($dir_path) {
        if (is_dir($dir_path)) {
            if ($dh = @opendir($dir_path)) {
                while (($sub_path = readdir($dh))) {
                    if ($sub_path === '.' || $sub_path === '..') {
                        continue;
                    } else if (is_dir("$dir_path/$sub_path")) {
                        $this->cleanDir("$dir_path/$sub_path");
                    } else {
                        unlink("$dir_path/$sub_path");
                    }
                }
                closedir($dh);
            }
            rmdir($dir_path);
        }
    }
}