<?php

namespace Mainto\RpcTool\Command;

use Illuminate\Console\Command;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Mainto\RpcTool\Document\Document;
use RuntimeException;

class RpcErrorCodeSync extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:exception_code_sync';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'exception code info sync to config center';

    public function handle () {
        // login
        $client = app(\GuzzleHttp\Client::class);
        $staffId = "603955";
        $timeStamp = now()->timestamp;
        $authName = "ci_robot";
        $permissions = [];
        sort($permissions);

        $authCode = "zf2CUdaxoIycRGBKZskEQ6hHY53VvXWt";
        $checkStr = "$staffId$authName$timeStamp$authCode".implode(",", $permissions);

        $checkCode = rtrim(base64_encode(md5($checkStr, true)), "=");
        $response = $client->post('https://api-gateway.hzmantu.com/manage_auth/login/adminCode', [
            'json' => [
                'authCode'    => sprintf("ci_robot.%d.%s", $timeStamp, $checkCode),
                'staffId'     => $staffId,
                'permissions' => $permissions,
            ],
        ]);
        if ($response->getStatusCode() != 200) {
            throw new RuntimeException("login fail. ".$response->getHeader('X-Trace-Id')[0]);
        }
        $xStreamId = $response->getHeader('X-Stream-Id')[0];

        $response = $client->get('https://cot.hzmantu.com/configerror/user/'.$xStreamId);
        if ($response->getStatusCode() != 200) {
            throw new RuntimeException($response->getBody()->getContents());
        }
        $data = json_decode($response->getBody()->getContents(), true);
        $token = $data['msg']['data']['token'];

        $document = Document::fromRpcDefinition(RpcDefinition::getInstance());
        $document->resolveEnumAndException();

        foreach ($document->exceptions as $exception) {
            foreach ($exception->codes as $code) {
                $code16 = "0x".strtoupper(dechex($code->code));
                $response = $client->post('https://cot.hzmantu.com/configerror/error/find', [
                    'headers' => [
                        'Authorization' => "Bearer ".$token,
                    ],
                    'json'    => [
                        'page' => 1,
                        'type' => 'code',
                        'text' => $code16,
                    ],
                ]);
                $contents = $response->getBody()->getContents();
                $data = json_decode($contents, true);

                if (count($data['msg']['data']) > 0) {
                    $needUpdate = true;
                    $codeData = $data['msg']['data'][0];
                    foreach ($codeData['messages'] as $key => $message) {
                        if (in_array('default', $message['tags'])) {
                            if ($message['message'] == $code->comment) {
                                echo "$code16 错误码无更新忽略".PHP_EOL;
                                $needUpdate = false;
                                // ignore
                                break;
                            }
                            unset($codeData['messages'][$key]);
                        }
                    }
                    if ($needUpdate) {
                        $codeData['messages'][] = [
                            "message" => $code->comment,
                            "tags"    => ["default"],
                        ];
                        $codeData['messages'] = array_values($codeData['messages']);

                        $response = $client->post('https://cot.hzmantu.com/configerror/error/update', [
                            'headers' => [
                                'Authorization' => "Bearer ".$token,
                            ],
                            'json'    => $codeData,
                        ]);
                        if ($response->getStatusCode() == 200) {
                            echo "$code16 更新错误码平台成功".PHP_EOL;
                        } else {
                            echo "$code16 更新错误码平台失败".$contents.PHP_EOL;
                        }
                    }
                } else {
                    $response = $client->put('https://cot.hzmantu.com/configerror/error/create', [
                        'headers' => [
                            'Authorization' => "Bearer ".$token,
                        ],
                        'json'    => [
                            "code"     => $code16,
                            "messages" => [
                                [
                                    "message" => $code->comment,
                                    "tags"    => "default",
                                ],
                            ],
                        ],
                    ]);
                    if ($response->getStatusCode() == 200) {
                        echo "$code16 同步错误码平台成功".PHP_EOL;
                    } else {
                        echo "$code16 同步错误码平台失败".$contents.PHP_EOL;
                    }
                }
            }
        }
    }
}