<?php

namespace Mainto\RpcTool\TestHelper\Factory;


use Faker\Provider\Base;
use Illuminate\Support\Arr;
use Mainto\RpcServer\RpcAnnotations\Alias;

/**
 * Class Util
 * @package Mainto\RpcServer\TestHelper\Factory
 * @Alias(name="test faker 工具类")
 */
class Util extends Base {
    const SUPPORT_TYPES = [
        "string", "bool", "int", "uint", "double", "unsignedDouble",
        "array", "array<int>", "array<uint>", "array<string>",
    ];

    /**
     * @param $needle
     * @return array
     * @throws \Exception
     */
    public static function notType ($needle) {
        $support = array_flip(self::SUPPORT_TYPES);
        if (!isset($support[$needle])) {
            throw new \Exception('You type is not support');
        }
        if ($needle == 'array') {
            unset($support['array<int>'], $support['array<uint>'], $support['array<string>']);
        }

        if ($needle == 'array<int>') {
            unset($support['array<uint>']);
        }

        if ($needle == 'array<uint>') {
            unset($support['array<int>']);
        }

        if ($needle == 'double') {
            unset($support['unsignedDouble'], $support['uint'], $support['int']);
        }

        if ($needle == 'unsignedDouble') {
            unset($support['double'], $support['uint'], $support['int']);
        }

        if ($needle == 'int') {
            unset($support['uint'], $support['unsignedDouble'], $support['double']);
        }

        if ($needle == 'uint') {
            unset($support['int'], $support['unsignedDouble'], $support['double']);
        }

        unset($support[$needle]);
        $values = [];
        foreach ($support as $type => $_) {
            $values[] = self::getTypeValue($type, true);
        }
        return $values;
    }

    /**
     * @return array
     * @throws \Exception
     */
    public static function typeValues () {
        $support = array_flip(self::SUPPORT_TYPES);
        $values = [];
        foreach ($support as $type => $_) {
            $values[] = self::getTypeValue($type, true);
        }
        return $values;
    }

    /**
     * @param $needle
     * @param bool $only
     * @return array|bool|int|string
     * @throws \Exception
     */
    private static function getTypeValue ($needle, $only = false) {
        switch ($needle) {
            case 'string':
                return self::string();
            case 'bool':
                return self::bool();
            case 'int':
                return $only ? self::intExceptUInt() : self::int();
            case 'uint':
                return $only ? self::uintExceptInt() : self::uint();
            case 'double':
                return $only ? self::doubleExceptUnsignedDouble() : self::double();
            case 'float':
                return self::float();
            case 'unsignedDouble':
                return self::unsignedDouble();
            case 'array':
                return self::randomArray();
            case 'array<int>':
                return $only ? self::arrayIntExceptUint() : self::arrayInt();
            case 'array<uint>':
                return $only ? self::arrayUIntExceptInt() : self::arrayUInt();
            case 'array<string>':
                return self::arrayString();
            default:
                return self::arrayString();
        }
    }

    public static function unsignedDouble ($max = 999999999999) {
        return 0 + mt_rand() / mt_getrandmax() * ($max - 0);
    }

    public static function float ($min = -999999999999, $max = 999999999999) {
        return $min + mt_rand() / mt_getrandmax() * ($max - $min);
    }

    public static function double ($min = -999999999999, $max = 999999999999) {
        return $min + mt_rand() / mt_getrandmax() * ($max - $min);
    }

    public static function doubleExceptUnsignedDouble ($max = 999999999999) {
        return self::unsignedDouble($max);
    }

    public static function uint () {
        return self::numberBetween(0, 4294967295);
    }

    public static function uintExceptInt () {
        return self::numberBetween(2147483648, 4294967295);
    }

    public static function int () {
        return self::numberBetween(-2147483648, 2147483647);
    }

    public static function intExceptUInt () {
        return self::numberBetween(-2147483648, -1);
    }

    protected static $string = 'qwertyuiopasdfghjklzxcvbnm';

    public static function string ($length = '') {
        if (!$length) {
            return self::shuffleString(self::$string);
        }
        return substr(str_repeat(self::shuffleString(self::$string), ceil($length / 26)), 0, $length);
    }

    /**
     * @param int $length
     * @return array
     * @throws \Exception
     */
    public static function randomArray ($length = 5) {
        $arr = [];
        for ($i = 0; $i < $length; $i++) {
            $arr[] = Arr::random(self::notType('array'), 1)[0];
        }
        return $arr;
    }

    public static function arrayInt ($length = 5) {
        $arr = [];
        for ($i = 0; $i < $length; $i++) {
            $arr[] = self::int();
        }
        return $arr;
    }

    public static function arrayIntExceptUint ($length = 5) {
        $arr = [];
        for ($i = 0; $i < $length; $i++) {
            $arr[] = self::intExceptUInt();
        }
        return $arr;
    }

    public static function arrayUInt ($length = 5) {
        $arr = [];
        for ($i = 0; $i < $length; $i++) {
            $arr[] = self::uint();
        }
        return $arr;
    }

    public static function arrayUIntExceptInt ($length = 5) {
        $arr = [];
        for ($i = 0; $i < $length; $i++) {
            $arr[] = self::uintExceptInt();
        }
        return $arr;
    }

    /**
     * @Alias(name="获取一个array<string>值")
     * @param int $length
     * @return array
     */
    public static function arrayString (int $length = 5) {
        $arr = [];
        for ($i = 0; $i < $length; $i++) {
            $arr[] = self::string();
        }
        return $arr;
    }

    public static function bool () {
        return (bool)rand(0, 1);
    }

    public static function moreThanLengthString ($length) {
        return self::string($length).'s';
    }

    public static function lessThanLengthString ($length) {
        return substr(self::string($length), 0, -1);
    }
}