<?php
/**
 * Created by PhpStorm.
 * User: liuzaisen
 * Date: 2018/10/18
 * Time: 2:52 PM
 */

namespace Mainto\RpcTool\TestHelper\Factory;


use Faker\Factory;

class MaintoFactory extends Factory {
    protected static $providers = [
        'Store', 'Staff', 'Util',
    ];

    /**
     * @param string $locale
     * @return \Faker\Generator | Generator
     */
    public static function create ($locale = 'zh_CN') {
        $generator = parent::create($locale);

        foreach (self::$providers as $provider) {
            $generator->addProvider(self::findClassName($provider));
        }

        return $generator;
    }

    /**
     * @param string $provider
     * @return string
     */
    protected static function findClassName (string $provider) {
        $providerClass = 'Mainto\RpcTool\TestHelper\Factory\\'.$provider;
        if (class_exists($providerClass, true)) {
            return $providerClass;
        }

        throw new \InvalidArgumentException(sprintf('Unable to find provider "%s"', $provider, ));
    }
}