<?php


namespace Mainto\RpcTool\Providers;


use Illuminate\Support\ServiceProvider;
use Mainto\RpcTool\Command\RpcSdkPHPCommand;
use Mainto\RpcTool\Command\RpcDocClean;
use Mainto\RpcTool\Command\RpcDocUpload;
use Mainto\RpcTool\Command\RpcSdkJSDump;
use Mainto\RpcTool\Command\RpcMakeControllerTestClass;
use Mainto\RpcTool\Command\RpcMockDump;
use Mainto\RpcTool\Command\RpcSdkJsonDump;

class RpcToolServiceProvider extends ServiceProvider {
    public function boot() {
        if ($this->app->runningInConsole()) {

            $this->publishes([
                __DIR__.'/../config.php' => config_path('rpc-tool.php'),
            ], 'config');
        }
    }

    public function register () {
        $this->mergeConfigFrom(__DIR__.'/../config.php', 'rpc-tool');

        $this->app['config']->set('view.paths', array_merge($this->app['config']->get('view.paths'), [
            __DIR__.'/../Command/dump-template',
        ]));

        $this->app->bind('command.rpc.dump.mock', RpcMockDump::class);
        $this->app->bind('command.rpc.make.controller_test', RpcMakeControllerTestClass::class);
        $this->app->bind('command.rpc.doc_upload', RpcDocUpload::class);
        $this->app->bind('command.rpc.doc_clean', RpcDocClean::class);
        $this->app->bind('command.rpc.sdk.php', RpcSdkPHPCommand::class);
        $this->app->bind('command.rpc.sdk.js', RpcSdkJSDump::class);
        $this->app->bind('command.rpc.sdk.json', RpcSdkJsonDump::class);

        $this->commands([
            'command.rpc.dump.mock',
            'command.rpc.make.controller_test',
            'command.rpc.doc_upload',
            'command.rpc.doc_clean',
            'command.rpc.sdk.php',
            'command.rpc.sdk.json',
            'command.rpc.sdk.js',
        ]);
    }
}