
namespace Mainto\Bridge\Invokes\{{$namespace}};

use {{$rpcClassNamespace}};
use {{$mockClassNamespace}};
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
@foreach($methods as $method)
@if(!$method->isObjectRequest)
 * @@method {{$method->name}}ByParams(array $params)
@else
 * @@method {{$method->name}}ByParams(array|{{ $method->docRequestType }} $params)
@endif
@endforeach
 */
class {{$shortClassName}} {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

@foreach($methods as $method)
    /**
@if($method->description)
@foreach(explode("\n", $method->description) as $doc)
     * {{$doc}}
@endforeach
@else
     * {{$method->alias}}
@endif
@if($method->deprecated)
     * @deprecated
@endif
     *
@if(!$method->isObjectRequest)
@foreach ($method->rpcParams as $param)
@if($param->isParameter)
     * @param {!! $param->type !!} ${{$param->name}} {{$param->comment}} {{$param->require ? '[ require true ]' : '[ require false ]'}}
@else
     * @support {!! $param->type !!} ${{$param->name}} {{$param->comment}} {{$param->require ? '[ require true ]' : '[ require false ]'}}
@endif
@endforeach
     * @throws \Exception
     * @return {!! $method->docResponseType !!}
     */
    public static function {{$method->name}} ({!! $method->parameterStr !!}) {
@if($method->rpcParams)
@if($method->isObjectResponse)
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->{{$method->name}}([
            @foreach($method->parametersMap as $param)
                "{{$param->name}}" => ${{$param->name}},
            @endforeach
            ]),
            "{!! $method->docResponseType !!}"
        );
@else
        return self::getClass()->{{$method->name}}([
@foreach($method->parametersMap as  $param)
            "{{$param->name}}" => ${{$param->name}},
@endforeach
        ]);
@endif
@else
        return self::getClass()->{{$method->name}}();
@endif
    }
@else
     * @var {!! $method->docRequestType !!} ${!! \Illuminate\Support\Arr::first($method->parametersMap)->name !!}
     * @throws \Exception
     * @return {!! $method->docResponseType !!}
     */
    public static function {{$method->name}} ({!! $method->parameterStr !!}) {
@if($method->isObjectResponse)
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->{{$method->name}}(${!! \Illuminate\Support\Arr::first($method->parametersMap)->name !!}),
            "{!! $method->docResponseType !!}"
        );
@else
        return self::getClass()->{{$method->name}}(${!! \Illuminate\Support\Arr::first($method->parametersMap)->name !!});
@endif
    }

@endif

@endforeach
    /**
     * getClass
     * @deprecated
     * @throws \Exception
     * @return mixed
     */
    public static function getClass () {
        return RpcClass::getClass('{{$microName}}', '{{$className}}');
    }

    /**
     * registerMock
     * @throws \Exception
     * @return RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('{{$microName}}', '{{$className}}');
    }

    /**
     * @param $name
     * @param $arguments
     * @return mixed
     * @throws \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}