
namespace Mainto\Bridge\Invokes\{{$namespace}};

use {{$rpcClassNamespace}};
use {{$mockClassNamespace}};
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
@foreach($methods as $method)
@if(!parameters_object($method->getParameters()))
 * @@method {{$method->name}}ByParams(array $params)
@else
 * @@method {{$method->name}}ByParams(array|{{ $shortClassName . '\\'. safe_namespace(\Illuminate\Support\Str::studly($method->name)).'\\'.\Mainto\RpcServer\RpcServer\RpcDefinition::getInstance()->getStruct(parameters_object($method->getParameters())->type)->name }} $params)
@endif
@endforeach
 */
class {{$shortClassName}} {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

@foreach($methods as $method)
    /**
@if($method->description)
@foreach(explode("\n", $method->description) as $doc)
     * {{$doc}}
@endforeach
@else
     * {{$method->alias}}
@endif
@if($method->deprecated)
     * @deprecated
@endif
     *
@if(!parameters_object($method->getParameters()))
@foreach (Mainto\RpcServer\RpcServer\RpcDefinition::getInstance()->getStruct($method->requestType)->properties as $property)
@if(isset(parameters_to_array($method->getParameters())[$property->name]))
     * @param {!! rpc_param_type($property->type) !!} ${{$property->name}} {{$property->comment}} [ require true ]
@else
     * @support {!!  rpc_param_type($property->type)  !!} ${{$property->name}} {{$property->comment}} {{$property->require ? '[ require true ]' : 'require false'}}
@endif
@endforeach
     * @throws \Exception
     * @return {{ response_type($shortClassName, $method->name, $method->responseType) }}
     */
    public static function {{$method->name}} ({!! parameters_to_str($shortClassName, $method->name, $method->getParameters()) !!}) {
@if(parameters_to_array($method->getParameters()))
@if(response_is_object($method->responseType))
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->{{$method->name}}([
            @foreach(parameters_to_array($method->getParameters()) as $name => $_)
                "{{$name}}" => ${{$name}},
            @endforeach
            ]),
            "\Mainto\Bridge\Invokes\{{$namespace}}\{{ response_type($shortClassName, $method->name, $method->responseType) }}"
        );
@else
        return self::getClass()->{{$method->name}}([
@foreach(parameters_to_array($method->getParameters()) as $name => $_)
            "{{$name}}" => ${{$name}},
@endforeach
        ]);
@endif
@else
        return self::getClass()->{{$method->name}}();
@endif
    }
@else
     * @var {{ parameters_object($method->getParameters())->nullable ? 'null|' : '' }}{!! $shortClassName.'\\'.safe_namespace(\Illuminate\Support\Str::studly($method->name)).'\\'.\Mainto\RpcServer\RpcServer\RpcDefinition::getInstance()->getStruct(parameters_object($method->getParameters())->type)->name.' $'.parameters_object($method->getParameters())->name !!} ${{parameters_object($method->getParameters())->name}}
     * @throws \Exception
     * @return {{ response_type($shortClassName, $method->name, $method->responseType) }}
     */
    public static function {{$method->name}} ({!! parameters_to_str($shortClassName, $method->name, $method->getParameters()) !!}) {
@if(response_is_object($method->responseType))
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->{{$method->name}}(${{parameters_object($method->getParameters())->name}}),
            "\Mainto\Bridge\Invokes\{{$namespace}}\{{ response_type($shortClassName, $method->name, $method->responseType) }}"
        );
@else
        return self::getClass()->{{$method->name}}(${{parameters_object($method->getParameters())->name}});
@endif
    }

@endif

@endforeach
    /**
     * getClass
     * @deprecated
     * @throws \Exception
     * @return mixed
     */
    public static function getClass () {
        return RpcClass::getClass('{{$microName}}', '{{$className}}');
    }

    /**
     * registerMock
     * @throws \Exception
     * @return RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('{{$microName}}', '{{$className}}');
    }

    /**
     * @param $name
     * @param $arguments
     * @return mixed
     * @throws \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}