<?php


namespace Mainto\RpcTool\Document;


use Illuminate\Support\Str;
use Mainto\RpcServer\RpcServer\Definition\Deprecated;
use Mainto\RpcServer\RpcServer\Definition\HttpApi;
use Mainto\RpcServer\RpcServer\Definition\ReqHeader;
use Mainto\RpcServer\RpcServer\Definition\ResHeader;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Mainto\RpcServer\Util\ArrayHelper;
use Mainto\RpcServer\Util\Types\Map;

class Method {
    use ArrayHelper;

    /**
     * @var string
     */
    public string $name;

    /**
     * @var string
     */
    public string $controllerName;

    /**
     * @var string
     */
    public string $alias = "";

    /**
     * @var Deprecated|null
     */
    public ?Deprecated $deprecated = null;

    /**
     * @var string
     */
    public string $description = "";

    /**
     * @var HttpApi|null
     */
    public ?HttpApi $httpApi = null;

    /**
     * @var ReqHeader[]
     */
    public array $reqHeaders = [];

    /**
     * @var string
     */
    public string $requestType = RpcDefinition::EmptyType;

    /**
     * @var string
     */
    public string $responseType = "mixed";

    /**
     * @var string
     */
    public string $resSerialize = "Json";

    /**
     * @var ResHeader[]
     */
    public array $resHeaders = [];

    /**
     * @var bool
     */
    public bool $checkValidation = true;

    /**
     * @var bool
     */
    public bool $checkType = true;

    /**
     * @var array|null
     */
    public array $needAuthorities = [];

    /**
     * @var string|null
     */
    public ?string $wsRoom = null;

    /**
     * @var bool|null
     */
    public bool $wsNeedConnectMessage = false;

    /**
     * @var bool|null
     */
    public bool $wsNeedDisconnectMessage = false;

    /**
     * @var string|null
     */
    public ?string $messageHookName = null;

    /**
     * @var string|null
     */
    public ?string $cronSpec = null;

    /**
     * @var string|null
     */
    public ?string $cronHookName = null;

    /**
     * @var string
     */
    public string $since = "1.0.0";

    /**
     * @var Map<MethodRequestExample>
     */
    public Map $requestExamples;

    public static function fromDefinitionMethod (\Mainto\RpcServer\RpcServer\Definition\Method $method) {
        $docMethod = new self();
        $docMethod->requestExamples = new Map();
        $definitionRef = new \ReflectionClass($method);
        foreach ($definitionRef->getProperties(\ReflectionProperty::IS_PUBLIC) as $property) {
            if (property_exists($docMethod, $property->name)) {
                $setMethod = 'set'.Str::studly($property->name);
                if (method_exists($docMethod, $setMethod)) {
                    $docMethod->{$setMethod}($method->{$property->name});
                } else {
                    $docMethod->{$property->name} = $method->{$property->name};
                }
            }

        }

        return $docMethod;
    }
}