<?php


namespace Mainto\RpcTool\Document;


use Illuminate\Support\Str;
use Mainto\RpcServer\Util\ArrayHelper;
use Mainto\RpcServer\Util\Types\Map;

class Controller {
    use ArrayHelper;

    /**
     * @var string $name
     */
    public string $name;

    /**
     * @var string $registerName
     */
    public string $registerName;

    /**
     * @var string
     */
    public string $namespace;

    /**
     * @var Map<Method>|Method[]
     */
    public Map $methods;

    public static function fromDefinitionController (\Mainto\RpcServer\RpcServer\Definition\Controller $controller): Controller {
        $docController = new self();
        $definitionRef = new \ReflectionClass($controller);
        foreach ($definitionRef->getProperties(\ReflectionProperty::IS_PUBLIC) as $property) {
            if (property_exists($docController, $property->name)) {
                $setMethod = 'set'.Str::studly($property->name);
                if (method_exists($docController, $setMethod)) {
                    $docController->{$setMethod}($controller->{$property->name});
                } else {
                    $docController->{$property->name} = $controller->{$property->name};
                }
            }
        }

        return $docController;
    }

    public function setMethods(Map $methods) {
        $this->methods = new Map();
        foreach ($methods as $key => $method) {
            $this->methods->set($key, Method::fromDefinitionMethod($method));
        }
    }
}