<?php


namespace Mainto\RpcTool\Definition\Traits;


use Illuminate\Support\Str;
use RuntimeException;

trait FormatType {
    public function typeShortName ($supportNotObject = false) {
        $match = [];
        preg_match("/#objects@(.*)/", $this->type, $match);
        if (count($match) != 2) {
            if ($supportNotObject) {
                return $this->type;
            }
            throw new RuntimeException("not support this type: {$this->type}");
        }

        $typeArr = array_map(fn($item) => Str::ucfirst($item), explode('.', $match[1]));

        return array_pop($typeArr);
    }

    public function formatType () {
        $match = [];
        preg_match("/#objects@(.*)/", $this->type, $match);
        if (count($match) != 2) {
            return $this->type;
        }

        return implode('\\', array_map(fn($item) => Str::ucfirst($item), explode('.', $match[1])));
    }

    public function isObjectType () {
        $match = [];
        preg_match("/#objects@(.*)/", $this->type, $match);

        return count($match) == 2;
    }
}