<?php


namespace Mainto\RpcTool\Definition;


use Illuminate\Support\Str;
use Mainto\RpcServer\Util\ObjectMapper\JsonMapper;
use Mainto\RpcServer\Util\ObjectMapper\MapperInterface;
use RuntimeException;

class Parser {
    public static ?MapperInterface $mapper = null;
    /**
     * @var Controller[]
     */
    public array $controllers = [];

    /**
     * @var ControllerObject[]
     */
    public array $objects = [];

    public function parse (string $path) {
        self::getMapper()->mapJsonArray(json_decode(file_get_contents($path), true), $this);
    }

    public static function getMapper () {
        if (!self::$mapper) {
            self::$mapper = new JsonMapper();
        }

        return self::$mapper;
    }

    public static function formatType(string $type) {
        $match = [];
        preg_match("/#objects@(.*)/", $type, $match);
        if (count($match) != 2) {
            return $type;
        }

        return implode('\\', array_map(fn($item) => Str::ucfirst($item), explode('.', $match[1])));
    }

    public static function formatNamespace(string $namespace) {
        return implode('\\', array_map(fn($item) => Str::ucfirst($item), explode('.', $namespace)));
    }

    public static function isObjectType(string $type) {
        $match = [];
        preg_match("/#objects@(.*)/", $type, $match);

        return count($match) == 2;
    }
}