namespace {{$controller->formatNamespace()}};

use Mainto\RpcServer\Base\Controller;
use Mainto\RpcServer\RpcAnnotations\RpcApi;
use Mainto\RpcServer\RpcAnnotations\RpcHeader;
use Mainto\RpcServer\RpcServer\RpcContext;
use Mainto\RpcServer\RpcAnnotations\Alias;
@foreach ($controller->methods as $method)
@if($method->request && !isset($types[$method->request->formatType()]))
use {{$types[$method->request->formatType()] = $method->request->formatType()}};
@endif
@if($method->response && $method->response->isObjectType() && !isset($types[$method->response->formatType()]))
use {{$types[$method->response->formatType()] = $method->response->formatType()}};
@endif
@endforeach

class {{$controller->name}} extends Controller {
@foreach ($controller->methods as $method)
    /**
@foreach (explode("\n", $method->description) as $desc)
     * {{$desc}}
@endforeach
@if($method->alias)
     * @Alias(name="{{$method->alias}}")
@endif
@if($method->api)
     * @RpcApi(method="{{$method->api->method}}", url="{{$method->api->url}}")
@endif
@foreach ($method->headers as $header)
     * @RpcHeader(name="{{$header->name}}")
@endforeach
     *
     * @param RpcContext $context
@if($method->request)
     * @param {{$method->request->typeShortName()}} ${{str_camel($method->request->typeShortName())}}
@endif
     * @return {{$method->response->typeShortName(true)}}
     */
@if($method->request)
    public function {{$method->name}} (RpcContext $context, {{$method->request->typeShortName()}} ${{str_camel($method->request->typeShortName())}}): {{$method->response->typeShortName(true)}} {
@else
    public function {{$method->name}} (RpcContext $context): {{$method->response->typeShortName(true)}} {
@endif
    }
@endforeach
}
