<?php


namespace Mainto\RpcTool\Command;


use Illuminate\Console\Command;
use Mainto\RpcTool\Definition\Parser;

class RpcMakeController extends Command {
    protected $signature = 'rpc:make-controller {--definition_path=} {--base_controller_namespace=} {--base_object_namespace=} {--output_dir=}';

    public function handle () {
        $path = $this->option('definition_path');
        $baseNamespace = $this->option('base_controller_namespace');
        $baseObjectNamespace = $this->option('base_object_namespace');
        $outputDir = $this->option('output_dir');
        $parser = new Parser();
        $parser->parse($path);

        foreach ($parser->controllers as $controller) {
            $fileName = path_join(
                $outputDir,
                'Controllers',
                str_replace([$baseNamespace, "\\"], ["", "/"], $controller->formatNamespace()),
                $controller->name.'.php'
            );
            if (!file_exists(dirname($fileName))) {
                mkdir(dirname($fileName), 0775, true);
            }

            file_put_contents($fileName, "<?php\n".view('controller', [
                    'controller' => $controller,
                ])->render());
        }

        foreach ($parser->objects as $object) {
            $fileName = path_join(
                $outputDir,
                'Objects',
                str_replace([$baseObjectNamespace, "\\"], ["", "/"], $object->formatNamespace()),
                $object->name.'.php'
            );

            if (!file_exists(dirname($fileName))) {
                mkdir(dirname($fileName), 0775, true);
            }

            file_put_contents($fileName, "<?php\n".view('object', [
                    'object' => $object,
                ])->render());
        }
    }
}