<?php

namespace Mainto\RpcTool\Command;

use Illuminate\Console\Command;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Throwable;

class RpcSdkJsonDump extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:sdk-json {--dump_path=} {--base_namespace=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Service Api Dumper';

    public ?string $dumpPath;
    public ?string $baseNamespace;

    /**
     * Execute the console command.
     *
     * @return mixed
     * @throws Throwable
     */
    public function handle () {
        $dump_path = $this->option('dump_path');
        $this->dumpPath = rtrim($dump_path ?: format_path('.'), '/').'/';

        $version = RpcDefinition::getInstance()->version;
        $microName = RpcDefinition::getInstance()->serviceName;
        file_exists($this->dumpPath) || mkdir($this->dumpPath, 0777, true);
        $serviceJsonPath = $this->dumpPath."service.json";
        file_put_contents($serviceJsonPath, json_encode(RpcDefinition::getInstance()->toArray(), JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
        $this->comment(">>>> write service.json {serviceName: {$microName}, version: {$version} ...} to {$serviceJsonPath}");

        return 0;
    }
}
