<?php

namespace Mainto\RpcTool\Command;

use Illuminate\Console\Command;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Mainto\RpcTool\Document\Document;

class RpcMockDump extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:mock {--file_path=} {--dump_path=} {--write_provider=} {--write_json=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Router Dumper mock';

    /**
     * @var Document
     */
    protected Document $document;

    /**
     * 初始化文档信息
     */
    private function initDocument () {
        if (!$file_path = $this->option('file_path')) {
            $file_path = config('rpc-tool.micro_doc.doc_dir').'/definition.json';
        }

        if (file_exists($file_path)) {
            $this->document = unserialize(file_get_contents($file_path));
        } else {
            $this->document = Document::fromRpcDefinition(RpcDefinition::getInstance());
        }
    }

    /**
     * Execute the console command.
     *
     * @throws \Throwable
     */
    public function handle () {
        $this->initDocument();

        $serviceName = "";

        foreach ($this->document->controllers as $controller) {
            foreach ($controller->methods as $method) {
                $configPath = str_replace("\\", "/", $controller->name)."/{$method->name}".".json";
                $i = 0;
                $config = $method->requestExamples->mapWithKey(function($example) use(&$i) {
                    return [$i++ + 1 => $example['response']];
                });

                // 创建文件夹
                if (!file_exists(dirname($configPath))) {
                    mkdir(dirname($configPath), 0777, true);
                }

                // 写入数据
                print "write $configPath\n";
                file_put_contents($configPath, json_encode($config, JSON_PRETTY_PRINT));
            }
        }

        if ($this->option('write_provider')) {
            file_put_contents("../MockProvider.php", "<?php\n".view('mock-provider', [
                    'namespace'                 => $serviceName,
                    'runtimeExceptionNamespace' => config('rpc-tool.cmd.namespace.runtime_exception'),
                    'mockClassNamespace'        => config('rpc-tool.cmd.namespace.mock_class'),
                ])->render());
        }

        if ($this->option('write_json')) {
            file_put_contents("../../composer.json", json_encode([
                'name'        => 'mainto/micro-mock-'.str_replace("_", "-", snake_case($serviceName)),
                'homepage'    => 'https://code.hzmantu.com',
                'description' => "PHP {$serviceName} Serivce RPC Mock Data from MainTo Company",
                'keywords'    => ["micro core bridge {$serviceName} sdk mainto"],
                'license'     => ['MIT'],
                'require'     => ['php' => '^7.2.1'],
                'autoload'    => [
                    'psr-4' => [
                        "Mainto\\Bridge\\Mock\\{$serviceName}\\" => "src/",
                    ],
                ],
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
        }

        print "write success\n";
    }
}
