<?php


namespace Mainto\RpcTool\Document;


use Illuminate\Support\Str;
use Mainto\RpcServer\RpcServer\Definition\Enum;
use Mainto\RpcServer\RpcServer\Definition\Exception;
use Mainto\RpcServer\RpcServer\Definition\Struct;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Mainto\RpcServer\Util\ArrayHelper;
use Mainto\RpcServer\Util\Types\Map;

class Document {
    use ArrayHelper;

    /**
     * @var Map<Controller>|Controller[]
     */
    public Map $controllers;
    /**
     * @var Map<Struct>|Struct[]
     */
    public Map $structs;

    /**
     * @var Enum[]
     */
    public array $enums = [];

    /**
     * @var Exception[]
     */
    public array $exceptions = [];

    /**
     * @var string
     */
    public string $serviceName;

    /**
     * @var string
     */
    public string $serviceNameSnake;

    /**
     * @var string
     */
    public string $version;

    /**
     * @var array
     */
    public array $dependencies = [];

    /**
     * @var array
     */
    public array $docs = [];

    public static function fromRpcDefinition(RpcDefinition $definition): Document {
        $doc = new self();
        $definitionRef = new \ReflectionClass($definition);
        foreach ($definitionRef->getProperties(\ReflectionProperty::IS_PUBLIC) as $property) {
            if (property_exists($doc, $property->name)) {
                $setMethod = 'set'.Str::studly($property->name);
                if (method_exists($doc, $setMethod)) {
                    $doc->{$setMethod}($definition->{$property->name});
                } else {
                    $doc->{$property->name} = $definition->{$property->name};
                }
            }
        }

        return $doc;
    }

    public function setControllers(Map $controllers) {
        $this->controllers = new Map();
        foreach ($controllers as $key => $controller) {
            $this->controllers->set($key, Controller::fromDefinitionController($controller));
        }
    }
}