<?php
/**
 * Created by PhpStorm.
 * User: liuzaisen
 * Date: 2018/10/18
 * Time: 8:09 PM
 */

namespace Mainto\RpcTool\Command;


use GuzzleHttp\Client;
use Illuminate\Console\Command;
use Illuminate\Support\Str;
use Mainto\RpcServer\RpcServer\RpcDefinition;

class RpcDocUpload extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:doc_upload {--file_path=} {--doc_dir=} {--set_version=} {--base_path=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'upload document';

    /**
     * @var RpcDefinition
     */
    protected RpcDefinition $document;

    /**
     * RpcDocUpload constructor.
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @throws \Exception
     */
    public function handle () {
        $this->initDocument();
        $this->setVersion();
        $this->upload();
    }

    /**
     * 初始化文档信息
     */
    private function initDocument () {
        if (!$file_path = $this->option('file_path')) {
            $file_path = config('rpc-tool.micro_doc.doc_dir').'/definition.json';
        }

        if (file_exists($file_path)) {
            $this->document = unserialize(file_get_contents($file_path));
        } else {
            $this->document = RpcDefinition::getInstance();
        }
    }

    /**
     * 设置版本信息
     */
    private function setVersion () {
        $version = $this->option('set_version');

        if (!$version) {
            if (!$set_version = env('CI_COMMIT_REF_SLUG')) {
                if ($base_path = $this->option('base_path')) {
                    $git_file = $base_path.'/.git/HEAD';
                } else {
                    $git_file = base_path('/.git/HEAD');
                }

                if (!file_exists($git_file)) {
                    throw new \RuntimeException('get version fail');
                }

                $set_version = trim(str_replace(['ref: refs/heads/'], '', file_get_contents($git_file)));
                if (!$set_version) throw new \RuntimeException('get version fail');
            }
            $version = $set_version;
        }

        $this->document->version = safe_url_string($version);
    }

    /**
     * 上传文档
     */
    private function upload () {
        $skip = env('UPLOAD_SKIP_CONFIRM');
        $versionText = "{$this->document->serviceName}/{$this->document->version}";
        $domain = config('rpc-tool.micro_doc.doc_domain');

        if ($skip) {
            for ($i = 5; $i > 0; $i--) {
                $this->comment("\rstart upload to {$versionText} in $i seconds...");
                sleep(1);
            }
        } elseif (!$this->confirm("upload to {$versionText}?")) {
            $this->comment("cancel!");
            return;
        }
        file_put_contents(app_path('../test.json'), json_encode(array_merge(
            $this->document->toArray(),
            ["docs" => $this->getDocs()]
        ), JSON_UNESCAPED_UNICODE));

        $this->comment("uploading...");
        $client = new Client();
        $res = $client->post("{$domain}/@/api/service/version/upload", [
            'json' => array_merge(
                $this->document->toArray(),
                ["docs" => $this->getDocs()]
            ),
        ]);

        $this->comment((string)$res->getBody());
    }

    /**
     * 处理文档
     */
    private function getDocs (): array {
        $doc_dir = $this->option('doc_dir');
        if (!$doc_dir) $doc_dir = base_path('doc');

        $doc = [];

        if (file_exists($doc_dir)) {
            $docFiles = get_files($doc_dir);
            foreach ($docFiles as $filePath) {
                if (!Str::endsWith($filePath, '.md')) continue;

                $path = str_replace($doc_dir, "", $filePath);

                $doc[] = [
                    'path'    => $path,
                    'content' => file_get_contents($filePath),
                ];
            }
        }

        return $doc;
    }
}
