<?php

use Illuminate\Support\Str;
use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcServer\Definition\Parameter;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use Mainto\RpcServer\RpcServer\RpcObject;
use Mainto\RpcServer\Util\Language;

if (!function_exists('short_type')) {
    function short_type($type) {
        if (in_array($type, Language::$simpleType)) {
            return $type;
        }

        return class_basename($type);
    }
}

if (!function_exists('is_language_type')) {
    function is_language_type($type) {
        return in_array($type, Language::$simpleType);
    }
}

if (!function_exists('parameters_to_str')) {
    function parameters_to_str($parameters) {
        $argStr = "";
        /** @var Parameter $parameter */
        foreach ($parameters as $name => $parameter) {
            if ($parameter->type == RpcClass::class) continue;
            if (is_subclass_of($parameter->type, RpcObject::class)) {
                $argStr = "";
                foreach (RpcDefinition::getInstance()->getStruct($parameter->type)->properties as $property) {
                    $argStr .= $property->type.' $'.$property->name;
                    $argStr .= $property->defaultValueAvailable ? ' = '.var_export_min($property->default) : '';
                    $argStr .= ', ';
                }

                return rtrim($argStr, ', ');
            }

            $argStr .= $parameter->type.' $'.$parameter->name;
            $argStr .= $parameter->defaultValueAvailable ? ' = '.var_export_min($parameter->default) : '';
            $argStr .= ', ';
        }

        return rtrim($argStr, ', ');
    }
}

if (!function_exists('parameters_to_array')) {
    function parameters_to_array($parameters) {
        $array = [];
        /** @var Parameter $parameter */
        foreach ($parameters as $name => $parameter) {
            if ($parameter->type == RpcClass::class) continue;
            if (is_subclass_of($parameter->type, RpcObject::class)) {
                $array = [];
                foreach (RpcDefinition::getInstance()->getStruct($parameter->type)->properties as $property) {
                    $array[$property->name] = $property;
                }

                return $array;
            }
            $array[$parameter->name] = $parameter;
        }

        return $array;
    }
}

if (!function_exists('str_camel')) {
    function str_camel ($str) {
        return Str::camel($str);
    }
}

if (!function_exists('array_map_with_key')) {
    function array_map_with_key (callable $cb, array $array) {
        $map = [];
        foreach ($array as $key => $value) {
            $map += $cb($value, $key);
        }

        return $map;
    }
}

if (!function_exists('var_export_min')) {
    /**
     * dump var
     *
     * @param $var
     * @param bool $return
     * @return mixed|string
     */
    function var_export_min ($var, $return = true) {
        if (is_array($var)) {
            $toImplode = [];
            foreach ($var as $key => $value) {
                $toImplode[] = var_export($key, true).' => '.var_export_min($value, true);
            }
            $code = '['.implode(',', $toImplode).']';
            if ($return) return $code;
            else echo $code;
        } else {
            return var_export($var, $return);
        }
    }
}

if (!function_exists('del_file_tree')) {
    /**
     * Delete file tree
     *
     * @param $dir
     * @return bool
     */
    function del_file_tree ($dir) {
        $files = array_diff(scandir($dir), ['.', '..']);
        foreach ($files as $file) {
            (is_dir("$dir/$file")) ? del_file_tree("$dir/$file") : unlink("$dir/$file");
        }
        return rmdir($dir);
    }
}

if (!function_exists('get_files')) {
    /**
     * Get files
     * @param $dir
     * @return array
     */
    function get_files ($dir) {
        $files = [];
        $scan = scandir($dir);
        foreach ($scan as $item) {
            if ($item == '.' || $item == '..') continue;
            if (is_dir($dir.'/'.$item)) {
                $files = array_merge($files, get_files($dir.'/'.$item));
            } else {
                $files[] = $dir.'/'.$item;
            }
        }
        return $files;
    }
}

if (!function_exists('format_path')) {
    /**
     * Format the relative path as an absolute path with the current working directory as the reference
     *
     * @param $path
     * @return string
     */
    function format_path ($path) {
        if ($path[0] == ".") {
            $path = getcwd()."/{$path}";
        }

        $path = str_replace(['/', '\\'], DIRECTORY_SEPARATOR, $path);
        $parts = array_filter(explode(DIRECTORY_SEPARATOR, $path), 'strlen');
        $absolutes = [];
        foreach ($parts as $part) {
            if ('.' == $part) continue;
            if ('..' == $part) {
                array_pop($absolutes);
            } else {
                $absolutes[] = $part;
            }
        }
        return "/".implode(DIRECTORY_SEPARATOR, $absolutes);
    }
}

if (!function_exists('safe_url_string')) {
    /**
     * replace the str except [\w,-,.] to '-'
     *
     * @param string $str
     * @return string
     */
    function safe_url_string (string $str) {
        return preg_replace('/[^\w\-_.]/m', '-', $str);
    }
}