/**
 * @source {{$namespace}}
 */
var {{$shortClassName}} = {

@foreach($methods as $method)
    /**
     * {{$method['alias']}}
@if($method['isDeprecated'])
     * @deprecated
@endif
     * @@method {{strtoupper($method['method'])}}
     * @param {Object} object
@foreach ($method['params'] as $param)
     * @support {{'{'.$param->type. '}'}} {{$param->name}} {{$param->comment}} {{$param->require ? '[ require true ]' : ''}}
@endforeach
     * @returns
     * @memberof {{$className}}
     */
    {{$method['name']}}: function (object, option) {
        return axiosInstance('{{strtolower($method['method'])}}', '/{{\Illuminate\Support\Str::snake($microName)}}{{$method['url']}}', object, option)
    },

@endforeach
}
module.exports = {{$shortClassName}};