
namespace Mainto\Bridge\Mock\{{$namespace}};

use {{$runtimeExceptionNamespace}};
use {{$mockClassNamespace}};

class MockProvider {
    /**
     * MockProvider constructor.
     *
     * @param RpcMockClass $mockClass
     * @param string $serviceName
     * @param string $className
     */
    public function __construct (RpcMockClass $mockClass, string $serviceName, string $className) {
        $dataPath = __DIR__."/data/".str_replace("\\", "/", $className);
        if (!file_exists($dataPath)) return;

        foreach (array_diff(scandir($dataPath), ['..', '.']) as $file) {
            $jsonContent = json_decode(file_get_contents($dataPath."/".$file), true);
            $methodName = substr($file, 0, -5);

            foreach ($jsonContent as $requestId => $responseData) {
                $mockClass->setCallbackMock($methodName, $this->genCallbackMock($responseData), $requestId);
            }
        }
    }

    private function genCallbackMock ($responseData): \Closure {
        return function ($args = []) use ($responseData) {
            if (!isset($responseData['success'])) {
                throw new RpcRuntimeException("response data is invalid!");
            }

            if ($responseData['success']) {
                return $responseData['msg'];
            } else {
                throw new RpcRuntimeException($responseData['error_msg'] ?? 'unknown', $responseData['error_code'] ?? 500);
            }
        };
    }
}