<?php
/**
 * Created by PhpStorm.
 * User: liuzaisen
 * Date: 2019/4/4
 * Time: 11:53 AM
 */

namespace Mainto\MRPCTool\TestHelper\Document;

use ArrayAccess;
use Doctrine\Common\Annotations\AnnotationReader;
use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Support\Collection;
use Mainto\RpcServer\RpcAnnotations\Alias;
use Mainto\RpcServer\RpcServer\RpcRouter;
use ReflectionClass;

/**
 * Class Group
 * @package Mainto\RpcServer\TestHelper\Document
 * @property $group_name
 * @property $group_path
 * @property Collection $group_api
 */
class Group implements Arrayable, ArrayAccess {
    /**
     * @return mixed
     */
    public function getGroupName () {
        return $this->group_name;
    }

    /**
     * @return mixed
     */
    public function getGroupPath () {
        return $this->group_path;
    }

    /**
     * @var string
     */
    protected string $group_name;

    /**
     * @var string
     */
    protected string $group_path;

    /**
     * @var Collection
     */
    protected Collection $group_api;

    /**
     * Document constructor.
     * @param array $params
     */
    private function __construct ($params = []) {
        foreach ($params as $key => $value) {
            if (property_exists($this, $key)) {
                $this->{$key} = $value;
            }
        }
    }

    /**
     * @param $group_name
     * @param $group_path
     * @return Group
     */
    public static function newGroup ($group_name, $group_path) {
        return new self([
            'group_name' => $group_name,
            'group_path' => $group_path,
            'group_api'  => collect([]),
        ]);
    }

    /**
     * @param $controller_name
     * @param $method_name
     * @return GroupApi
     * @throws \ReflectionException
     * @throws \Doctrine\Common\Annotations\AnnotationException
     */
    public function findGroupApi ($controller_name, $method_name) {
        $refClass = new ReflectionClass($controller_name);

        /** @var GroupApi $group_api */
        $group_api = $this->group_api->where('controller_name', str_replace('Controller', '', $refClass->getShortName()))
            ->where('method_name', $method_name)
            ->first();
        if (!$group_api) {
            $group_api = GroupApi::newGroupApi(RpcRouter::getInstance()->getControllerAlias($refClass->getName()), $method_name);
            $this->group_api->push($group_api);

        } else {
            $group_api->flush(RpcRouter::getInstance()->getControllerAlias($refClass->getName()));
        }

        return $group_api;
    }

    /**
     *
     * @param $className
     * @return string
     * @throws \Doctrine\Common\Annotations\AnnotationException
     * @throws \ReflectionException
     */
    public static function classNameToGroupName ($className) {
        $refClass = new ReflectionClass($className);
        $title = $refClass->getShortName();
        $reader = new AnnotationReader();
        $annotations = $reader->getClassAnnotations($refClass);
        foreach ($annotations as $annotation) {
            if ($annotation instanceof Alias) {
                $title = $annotation->name;
                break;
            }
        }

        return $title;
    }

    public function toArray () {
        return [
            'group_name' => $this->group_name,
            'group_path' => $this->group_path,
            'group_api'  => $this->group_api,
        ];
    }

    /**
     * Whether a offset exists
     * @link  http://php.net/manual/en/arrayaccess.offsetexists.php
     * @param mixed $offset <p>
     *                      An offset to check for.
     *                      </p>
     * @return boolean true on success or false on failure.
     *                      </p>
     *                      <p>
     *                      The return value will be casted to boolean if non-boolean was returned.
     * @since 5.0.0
     */
    public function offsetExists ($offset) {
        return property_exists($this, $offset);
    }

    /**
     * Offset to retrieve
     * @link  http://php.net/manual/en/arrayaccess.offsetget.php
     * @param mixed $offset <p>
     *                      The offset to retrieve.
     *                      </p>
     * @return mixed Can return all value types.
     * @since 5.0.0
     */
    public function offsetGet ($offset) {
        if (property_exists($this, $offset)) {
            return $this->{$offset};
        }
    }

    /**
     * Offset to set
     * @link  http://php.net/manual/en/arrayaccess.offsetset.php
     * @param mixed $offset <p>
     *                      The offset to assign the value to.
     *                      </p>
     * @param mixed $value  <p>
     *                      The value to set.
     *                      </p>
     * @return void
     * @since 5.0.0
     */
    public function offsetSet ($offset, $value) {
        // TODO: Implement offsetSet() method.
    }

    /**
     * Offset to unset
     * @link  http://php.net/manual/en/arrayaccess.offsetunset.php
     * @param mixed $offset <p>
     *                      The offset to unset.
     *                      </p>
     * @return void
     * @since 5.0.0
     */
    public function offsetUnset ($offset) {
        // TODO: Implement offsetUnset() method.
    }

    /**
     * @return Collection
     */
    public function getGroupApi (): Collection {
        return $this->group_api;
    }
}