<?php


namespace Mainto\MRPCTool\Command;


use Doctrine\Common\Annotations\AnnotationException;
use Doctrine\Common\Annotations\AnnotationReader;
use Mainto\RpcServer\RpcAnnotations\Alias;
use Mainto\RpcServer\RpcAnnotations\RpcApi;
use Mainto\RpcServer\RpcAnnotations\RpcCallWay;
use Mainto\RpcServer\RpcAnnotations\RpcParam;
use Mainto\RpcServer\Server\RpcContext;
use Mainto\RpcServer\Server\RpcRouter;
use Mainto\RpcServer\Service\RpcParameter;
use ReflectionException;
use ReflectionMethod;
use RuntimeException;

class RpcRouterExtend {
    /**
     * @param $baseNamespace
     * @param bool $ignoreOnlyRpc
     * @param bool $ignoreOnlyHttp
     * @param bool $ignoreNoUrl
     * @return array
     * @throws ReflectionException
     * @throws AnnotationException
     */
    public static function getRouterClassStruct ($baseNamespace, $ignoreOnlyRpc = false, $ignoreOnlyHttp = false, $ignoreNoUrl = false): array {
        $classStructMap = [];
        $reader = new AnnotationReader();

        foreach (RpcRouter::getInstance()->getClassInstancesMap() as $aliasName => $classItem) {
            ["classInstance" => $classInstance, "methodItems" => $methodItems] = $classItem;
            $className = $aliasName;
            $shortClassName = $className;
            // get short class name
            if (($pos = strrpos($className, '\\')) !== false) {
                $shortClassName = substr($className, $pos + 1);
            }

            foreach ($methodItems as $methodItem) {
                /** @var ReflectionMethod $method */
                /** @var RpcParameter $parameter */
                ["methodInstance" => $method] = $methodItem;
                //gen method blade

                $methodName = $method->getName();
                //parse params
                $methodBlade = [];
                $methodBlade['doc'] = [];
                $methodBlade['alias'] = $methodName;
                $methodBlade['name'] = $methodName;
                $methodBlade['isDeprecated'] = false;
                $methodBlade['params'] = [];
                $onlyRpc = false;
                $onlyHttp = false;
                $hasUrl = false;
                $annotations = $reader->getMethodAnnotations($method);
                foreach ($annotations as $annotation) {
                    if ($annotation instanceof RpcCallWay) {
                        if ($annotation->only == 'Rpc') {
                            $onlyRpc = true;
                        }
                        if ($annotation->only == 'Http') {
                            $onlyHttp = true;
                        }
                    }

                    if ($annotation instanceof Alias) {
                        $methodBlade['alias'] = $annotation->name;
                    }

                    if ($annotation instanceof RpcApi) {
                        $methodBlade['url'] = $annotation->url;
                        $methodBlade['method'] = $annotation->method;
                        $hasUrl = true;
                    }

                    if ($annotation instanceof RpcParam) {
                        $tempType = $annotation->type;
                        if ($annotation->type == "uint") $annotation->type = "int";
                        if (in_array($annotation->type, ["double", "unsignedDouble"])) $annotation->type = "float";
                        if (in_array($annotation->type, ["array", "array<int>", "array<uint>", "array<string>"])) $annotation->type = "array";

                        if ($annotation->require == true || in_array('required', explode('|', $annotation->validation))) {
                            $annotation->require = true;
                            $str = "{$annotation->type} \${$annotation->name}";
                            $paramStrArr[] = $str;
                        }
                        if ($tempType != $annotation->type) {
                            $annotation->comment .= sprintf(" [Original type %s]", $tempType);
                        }

                        $methodBlade['params'][$annotation->name] = $annotation;
                    }
                }
                if ($onlyRpc && $ignoreOnlyRpc) continue;
                if ($onlyHttp && $ignoreOnlyHttp) continue;
                if (!$hasUrl && $ignoreNoUrl) continue;

                //find deprecated and return
                $args = $method->getParameters();
                $methodBlade['argStr'] = '';
                $methodBlade['args'] = [];
                foreach ($args as $arg) {
                    if ($arg->getType() && ($arg->getType()->getName() == RpcContext::class || is_subclass_of($arg->getType()->getName(), RpcContext::class))) continue;
                    $_name = $arg->getName();

                    if (!isset($methodBlade['params'][$_name])) {
                        throw new RuntimeException('The param not defined in RpcParam: '.$methodName.' : '.$_name);
                    }
                    $type = $methodBlade['params'][$_name]->type;
                    $_argStr = $type.' $'.$_name;
                    $_argStr .= $arg->isDefaultValueAvailable() ? ' = '.var_export_min($arg->getDefaultValue()) : '';

                    $methodBlade['args'][] = $_name;
                    $methodBlade['argStr'] .= $_argStr;
                    $methodBlade['argStr'] .= ', ';
                }
                $methodBlade['argStr'] = trim($methodBlade['argStr'], ', ');

                $returnType = '';
                $docComment = $method->getDocComment();
                foreach (explode("\n", $docComment) as $line) {
                    if (strpos($line, '@') === false && strpos($line, '/') === false) {
                        $_doc = trim(str_replace('*', '', $line));
                        if (!$_doc) continue;
                        $methodBlade['doc'][] = $_doc;
                        continue;
                    }
                    if (!$methodBlade['isDeprecated'] && strpos($line, '@deprecated') !== false) {
                        $methodBlade['isDeprecated'] = true;
                    }
                    if (!$returnType && strpos($line, '@return') !== false) {
                        $returnType = trim(str_replace(['@return', '*'], '', $line));
                    }
                }
                if (!in_array($returnType, ['int', 'array', 'string', 'float'])) {
                    $returnType = 'mixed';
                }
                $methodBlade['returnType'] = $returnType;
                $methodBlade['doc'] = $methodBlade['doc'] ?: [$methodBlade['alias']];
                $namespace = explode('\\', str_replace($baseNamespace, '', get_class($classInstance)));
                array_pop($namespace);
                $classStructMap[substr($className, 0, -10)]['methods'][] = $methodBlade;
                $classStructMap[substr($className, 0, -10)]['namespace'] = implode('\\', $namespace);
                $classStructMap[substr($className, 0, -10)]['shortName'] = substr($shortClassName, 0, -10);
            }
        }

        return $classStructMap;
    }
}