<?php

namespace Mainto\RpcTool\TestHelper;

use Illuminate\Validation\ValidationException;
use Mainto\RpcTool\TestHelper\Factory\Generator;

/**
 *
 * Trait Util
 * @package Tests\Helper
 * @property Generator $test_faker
 * @deprecated
 */
trait TestHelper {
    /**
     * @var $test_faker Generator
     */
    public static $faker;

    public function getFaker () {
        if (self::$faker == null) {
            self::$faker = Generator::createFactory();
        }
        return self::$faker;
    }

    /**
     * @param $name
     * @return \Faker\Generator|Generator
     * @throws \Exception
     */
    public function __get ($name) {
        if ($name == 'test_faker') {
            return self::getFaker();
        }
        throw new \Exception('the property not found! ');
    }

    public function _testException ($validateMessage, \Closure $closure) {
        try {
            $closure();
            $this->assertTrue(false, 'The params miss validate! ');
        } catch (ValidationException $e) {
            $this->assertEquals($e->errors(), $validateMessage);
        } catch (\Throwable $e) {
            $this->assertEquals($e->getMessage(), $validateMessage);
        }
    }

    public function _testType ($type, $field, $params, \Closure $closure) {
        $testValues = $this->test_faker->notType($type);
        foreach ($testValues as $value) {
            $params[$field] = $value;
            $this->_testException("key `$field` is not a $type instance", function () use ($params, $closure) {
                $closure($params);
            });
        }
    }
}