<?php
/**
 * Created by PhpStorm.
 * User: liuzaisen
 * Date: 2018/9/4
 * Time: 下午4:35
 */

namespace Mainto\MRPCTool\Command;


use ReflectionClass;

trait RpcEnumDump {
    public ?string $baseEnumNamespace;

    /**
     * @param $projectName
     * @param $service
     * @param $microName
     * @throws \ReflectionException
     * @throws \Throwable
     */
    public function dumpEnum ($projectName, $service, $microName) {
        if (file_exists($this->dumpPath."/$projectName/src/Enums/{$microName}")) {
            del_file_tree($this->dumpPath."/$projectName/src/Enums/{$microName}");
        }
        mkdir($this->dumpPath."/$projectName/src/Enums/{$microName}", 0777, true);

        $enumPath = rtrim($this->dumpPath, '/').'/app/Enums';

        $enumFiles = get_files($enumPath);
        foreach ($enumFiles as $_name) {
            if (substr($_name, -8, 8) != 'Enum.php') {
                continue;
            }
            $namespace = $this->getNamespace($_name);
            $_nameArr = explode('/', $_name);
            $className = str_replace(['/', '.php'], ['\\', ''], array_pop($_nameArr));

            $enum = $namespace.'\\'.$className;

            $reflection = new ReflectionClass($enum);
            $simpleNamespace = trim(str_replace($this->baseEnumNamespace, '', $namespace), '/\\');
            $simpleNamespace = $simpleNamespace ? '/'.$simpleNamespace : '';
            $path = rtrim($this->dumpPath, '/')."/$projectName/src/Enums/{$microName}{$simpleNamespace}";
            $path = str_replace('\\', '/', "$path/{$className}.php");
            file_exists(pathinfo($path, PATHINFO_DIRNAME)) or mkdir(pathinfo($path, PATHINFO_DIRNAME), 0777, true);
            file_put_contents($path, "<?php\n".view('enum', [
                    'service'   => $service,
                    'microName' => $microName,
                    'className' => $className,
                    'constants' => $reflection->getConstants(),
                    'namespace' => str_replace('/', '\\', $simpleNamespace),
                ])->render());
        }
    }

    /**
     * @param $file
     * @return string
     * @throws \Exception
     */
    public function getNamespace ($file) {
        $fp = fopen($file, 'r');
        while ($line = fgets($fp)) {
            if (strpos($line, 'namespace') !== false) {
                fclose($fp);
                return trim(str_replace(['namespace', ';'], '', $line));
            }
        }
        fclose($fp);
        throw new \Exception('not found namespace!');
    }
}