<?php
/**
 * Created by PhpStorm.
 * User: liuzaisen
 * Date: 2019/4/4
 * Time: 11:50 AM
 */

namespace Mainto\MRPCTool\TestHelper\Document;


use Illuminate\Contracts\Support\Arrayable;
use Illuminate\Contracts\Support\Jsonable;
use Illuminate\Support\Collection;
use JsonSerializable;

/**
 * Class Base
 * @package Mainto\RpcServer\TestHelper\Document
 */
class Document implements JsonSerializable, Jsonable {
    private static Document $instance;
    /**
     * @var string
     */
    protected string $project;
    /**
     * @var string
     */
    protected string $project_service_name;
    /**
     * @var string
     */
    protected string $version;
    /**
     * @var Collection
     */
    protected Collection $exceptions;
    /**
     * @var Collection
     */
    protected Collection $api;
    /**
     * @var Collection
     */
    protected Collection $enums;
    /**
     * @var Collection
     */
    protected Collection $docs;

    /**
     * Document constructor.
     * @param array $params
     */
    private function __construct ($params = []) {
        foreach ($params as $key => $value) {
            if (property_exists($this, $key)) {
                $this->{$key} = $value;
            }
        }
    }

    /**
     * @return static
     */
    public static function getInstance () {
        if (!self::$instance) {
            self::$instance = new self([
                'project'              => snake_case(config('rpc-server.service_name')),
                'project_service_name' => config('rpc-server.service_name'),
                'enums'                => collect([]),
                'exceptions'           => collect([]),
                'api'                  => collect([]),
                'docs'                 => collect([]),
                'version'              => '',
            ]);
        }

        return self::$instance;
    }

    /**
     * @return mixed
     */
    public function getVersion () {
        return $this->version;
    }

    /**
     * @param string $version
     */
    public function setVersion (string $version) {
        $this->version = $version;
    }

    /**
     * @return Collection
     */
    public function getExceptions (): Collection {
        return $this->exceptions;
    }

    /**
     * @return Collection
     */
    public function getApi (): Collection {
        return $this->api;
    }

    /**
     * @return Collection
     */
    public function getEnums (): Collection {
        return $this->enums;
    }

    /**
     * @return Collection
     */
    public function getDocs (): Collection {
        return $this->docs;
    }

    /**
     * @param $class
     * @return Group
     * @throws \Doctrine\Common\Annotations\AnnotationException
     * @throws \ReflectionException
     */
    public function getGroup ($class) {
        $path_begin = config('rpc-server.micro_doc.path_begin');
        $simpleClassPath = explode('\\', str_replace($path_begin, '', $class));
        $group_path = trim(implode('|', array_map(function ($item) { return snake_case($item); }, $simpleClassPath)), '|');

        $group = $this->api->where('group_path', $group_path)->first();
        if (!$group) {
            $group = Group::newGroup(Group::classNameToGroupName($class), $group_path);
            $this->api->push($group);
        }
        return $group;
    }

    public function toJson ($options = 0) {
        return json_encode($this->jsonSerialize(), $options);
    }

    public function jsonSerialize () {
        return array_map(function ($value) {
            if ($value instanceof JsonSerializable) {
                return $value->jsonSerialize();
            } elseif ($value instanceof Jsonable) {
                return json_decode($value->toJson(), true);
            } elseif ($value instanceof Arrayable) {
                return $value->toArray();
            }

            return $value;
        }, $this->toArray());
    }

    public function toArray () {
        return [
            'project'              => $this->project,
            'project_service_name' => $this->project_service_name,
            'enums'                => $this->enums,
            'exceptions'           => $this->exceptions,
            'api'                  => $this->api,
            'docs'                 => $this->docs,
            'version'              => $this->version,
        ];
    }

    /**
     * @return string
     */
    public function getProject (): string {
        return $this->project;
    }

    /**
     * @return string
     */
    public function getProjectServiceName (): string {
        return $this->project_service_name;
    }
}