<?php

namespace Mainto\MRPCTool\Command;

use Illuminate\Console\Command;
use Mainto\MRPCTool\TestHelper\Document\Document;
use Mainto\MRPCTool\TestHelper\Document\Group;
use Mainto\MRPCTool\TestHelper\Document\GroupApi;
use Mainto\MRPCTool\TestHelper\Document\GroupApiRequestExample;

class RpcMockDump extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:mock {--file_path=} {--dump_path=} {--write_provider=} {--write_json=} {--runtime_exception_namespace=} {--mock_class_namespace=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Router Dumper mock';

    /**
     * @var Document
     */
    protected Document $document;

    private string $runtimeExceptionNamespace;

    private string $mockClassNamespace;

    /**
     * 初始化文档信息
     */
    private function initDocument () {
        if (!$file_path = $this->option('file_path')) {
            $file_path = config('rpc-server.micro_doc.doc_dir').'/micro_document.json';
        }

        if (!$this->runtimeExceptionNamespace = $this->option('runtime_exception_namespace')) {
            $this->runtimeExceptionNamespace = config('rpc-tool.cmd.mock_dump.runtime_exception_namespace');
        }

        if (!$this->mockClassNamespace = $this->option('mock_class_namespace')) {
            $this->mockClassNamespace = config('rpc-tool.cmd.mock_dump.mock_class_namespace');
        }

        if (file_exists($file_path)) {
            $this->document = unserialize(file_get_contents($file_path));
        } else {
            $this->document = Document::getInstance();
        }
    }

    /**
     * Execute the console command.
     *
     * @throws \Throwable
     */
    public function handle () {
        $this->initDocument();

        $serviceName = "";
        $this->document->getApi()->each(function (Group $group) use (&$serviceName) {
            $group->getGroupApi()->each(function (GroupApi $groupApi) use (&$serviceName) {
                // 准备数据
                $fileName = substr($groupApi->getBridgeNamespace(), 23);
                [$serviceName, $controllerName] = explode("\\", $fileName, 2);
                $configName = str_replace("\\", "/", $controllerName)."/{$groupApi->getMethodName()}".".json";
                $config = $groupApi->getRequestExample()->mapWithKeys(function (GroupApiRequestExample $requestExample, $i) {
                    return [$i + 1 => $requestExample->getResponse()];
                });

                // 创建文件夹
                if (!file_exists(dirname($configName))) {
                    mkdir(dirname($configName), 0777, true);
                }

                // 写入数据
                print "write $configName\n";
                file_put_contents($configName, json_encode($config, JSON_PRETTY_PRINT));
            });
        });

        if ($this->option('write_provider')) {
            file_put_contents("../MockProvider.php", "<?php\n".view('mock-provider', [
                    'namespace'                 => $serviceName,
                    'runtimeExceptionNamespace' => $this->runtimeExceptionNamespace,
                    'mockClassNamespace'        => $this->mockClassNamespace,
                ])->render());
        }

        if ($this->option('write_json')) {
            file_put_contents("../../composer.json", json_encode([
                'name'        => 'mainto/micro-mock-'.str_replace("_", "-", snake_case($serviceName)),
                'homepage'    => 'https://code.hzmantu.com',
                'description' => "PHP {$serviceName} Serivce RPC Mock Data from MainTo Company",
                'keywords'    => ["micro core bridge {$serviceName} sdk mainto"],
                'license'     => ['MIT'],
                'require'     => ['php' => '^7.2.1'],
                'autoload'    => [
                    'psr-4' => [
                        "Mainto\\Bridge\\Mock\\{$serviceName}\\" => "src/",
                    ],
                ],
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
        }

        print "write success\n";
    }
}
