<?php

namespace Mainto\MRPCTool\Command;

use Illuminate\Console\Command;
use ReflectionException;
use Throwable;

class RpcBridgeDump extends Command {
    use RpcEnumDump;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:dump {--dump_path=} {--write_json=} {--base_namespace=} {--base_enum_namespace=}';
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Router Dumper bridge';

    private string $microName;

    public ?string $dumpPath;
    public ?string $baseNamespace;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
        $this->microName = config('rpc-server.service_name', 'NoName');
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     * @throws ReflectionException
     * @throws Throwable
     */
    public function handle () {
        $dump_path = $this->option('dump_path');
        $write_json = $this->option('write_json');
        $base_namespace = $this->option('base_namespace');
        $this->dumpPath = $dump_path ?: format_path('.');
        $this->baseNamespace = $base_namespace ?: 'App\Rpc\Controllers\\';

        $base_enum_namespace = $this->option('base_enum_namespace');
        $this->baseEnumNamespace = $base_enum_namespace ?: 'App\Enums';

        $microName = camel_case(config('rpc-server.service_name', 'NoName'));
        $microName[0] = strtoupper($microName[0]);
        $this->dumpEnum('micro-bridge', 'Bridge', $microName);

        if (file_exists($this->dumpPath."/micro-bridge/src/Invokes/{$microName}")) {
            del_file_tree($this->dumpPath."/micro-bridge/src/Invokes/{$microName}");
        }
        mkdir($this->dumpPath."/micro-bridge/src/Invokes/{$microName}", 0777, true);

        foreach (RpcRouterExtend::getRouterClassStruct($this->baseNamespace, false, true) as $className => $item) {
            $path = $this->dumpPath."/micro-bridge/src/Invokes/{$microName}/".str_replace('\\', '/', $item['namespace']);
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
            }
            $item['namespace'] = $item['namespace'] ? $microName.'\\'.$item['namespace'] : $microName;
            file_put_contents("$path/{$item['shortName']}.php", "<?php\n".view('bridge-controller', [
                    'microName'      => $microName,
                    'className'      => $className,
                    'shortClassName' => $item['shortName'],
                    'methods'        => $item['methods'],
                    'namespace'      => $item['namespace'],
                ])->render());
        }
        if ($write_json){
            file_put_contents($this->dumpPath."/micro-bridge/composer.json", json_encode([
                'name'        => 'mainto/micro-bridge-'.str_replace("_", "-", snake_case($microName)),
                'homepage'    => 'https://code.hzmantu.com',
                'description' => "PHP {$microName} Serivce RPC Bridge from MainTo Company",
                'keywords'    => ["micro core bridge {$microName} sdk mainto"],
                'license'     => ['MIT'],
                'require'     => ['php' => '^7.2.1'],
                'autoload'    => [
                    'psr-4' => [
                        "Mainto\\Bridge\\Enums\\{$microName}\\"   => "src/Enums/{$microName}",
                        "Mainto\\Bridge\\Invokes\\{$microName}\\" => "src/Invokes/{$microName}",
                    ],
                ],
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES));
        }
        return;
    }
}
