<?php

namespace Mainto\MRPCTool\Command;

use Illuminate\Console\Command;
use ReflectionException;
use Throwable;

class RpcSdkDump extends Command {
    use RpcEnumDump;
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:dump-mainto-sdk {--dump_path=} {--base_namespace=} {--base_enum_namespace=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Router Dumper mainto-sdk';

    public ?string $dumpPath;
    public ?string $baseNamespace;
    /**
     * ===========================================================
     * Dump IDE End
     */

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct () {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     * @throws ReflectionException
     * @throws Throwable
     */
    public function handle () {
        $dump_path = $this->option('dump_path');
        $base_namespace = $this->option('base_namespace');
        $this->dumpPath = $dump_path ?: format_path('.');
        $this->baseNamespace = $base_namespace ?: 'App\Rpc\Controllers\\';

        $base_enum_namespace = $this->option('base_enum_namespace');
        $this->baseEnumNamespace = $base_enum_namespace ?: 'App\Enums';

        $microName = camel_case(config('rpc-server.service_name', 'NoName'));
        $microName[0] = strtoupper($microName[0]);
        $this->dumpEnum('micro-core-sdk', 'Sdk', $microName);

        if (file_exists($this->dumpPath."/micro-core-sdk/src/Invokes/{$microName}")) {
            del_file_tree($this->dumpPath."/micro-core-sdk/src/Invokes/{$microName}");
        }
        mkdir($this->dumpPath."/micro-core-sdk/src/Invokes/{$microName}", 0777, true);

        foreach (RpcRouterExtend::getRouterClassStruct($this->baseNamespace, true, false, true) as $className => $item) {
            $path = $this->dumpPath.("/micro-core-sdk/src/Invokes/{$microName}/".str_replace('\\', '/', $item['namespace']));
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
            }
            $item['namespace'] = $item['namespace'] ? $microName.'\\'.$item['namespace'] : $microName;
            file_put_contents("$path/{$item['shortName']}.php", "<?php\n".view('sdk-controller', [
                    'microName'      => $microName,
                    'className'      => $className,
                    'shortClassName' => $item['shortName'],
                    'methods'        => $item['methods'],
                    'namespace'      => $item['namespace'],
                ])->render());
        }
        return;
    }
}
