<?php


namespace Mainto\RpcTool\Providers;


use Illuminate\Support\ServiceProvider;
use Mainto\RpcTool\Command\RpcBridgeDump;
use Mainto\RpcTool\Command\RpcDocClean;
use Mainto\RpcTool\Command\RpcDocUpload;
use Mainto\RpcTool\Command\RpcJsSdkDump;
use Mainto\RpcTool\Command\RpcMakeControllerTestClass;
use Mainto\RpcTool\Command\RpcSdkDump;
use Mainto\RpcTool\Command\RpcServiceApiDump;

class RpcToolServiceProvider extends ServiceProvider {
    public function boot() {
        if ($this->app->runningInConsole()) {

            $this->publishes([
                __DIR__.'/../config.php' => config_path('rpc-tool.php'),
            ], 'config');
        }
    }

    public function register () {
        $this->mergeConfigFrom(__DIR__.'/../config.php', 'rpc-tool');

        $this->app['config']->set('view.paths', array_merge($this->app['config']->get('view.paths'), [
            __DIR__.'/../Command/dump-template',
        ]));

        $this->app->bind('command.rpc.dump.bridge', RpcBridgeDump::class);
        $this->app->bind('command.rpc.dump.sdk', RpcSdkDump::class);
        $this->app->bind('command.rpc.make.controller_test', RpcMakeControllerTestClass::class);
        $this->app->bind('command.rpc.dump.js-sdk', RpcJsSdkDump::class);
        $this->app->bind('command.rpc.dump.service-api', RpcServiceApiDump::class);
        $this->app->bind('command.rpc.doc_upload', RpcDocUpload::class);
        $this->app->bind('command.rpc.doc_clean', RpcDocClean::class);

        $this->commands([
            'command.rpc.dump.bridge',
            'command.rpc.dump.service-api',
            'command.rpc.dump.sdk',
            'command.rpc.dump.js-sdk',
            'command.rpc.make.controller_test',
            'command.rpc.doc_upload',
            'command.rpc.doc_clean',
        ]);
    }
}