<?php

namespace Mainto\RpcTool\Command;

use Illuminate\Console\Command;
use Throwable;

class RpcJsSdkDump extends Command {
    public const BASE_DIR_NAME = 'mainto-micro-jssdk';

    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:dump-mainto-sdk-js {--build-version} {--branch=} {--dump_path=} {--base_namespace=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'RPC Router Dumper';

    public ?string $dump_path;
    public ?string $baseNamespace;

    public static function versionPlus ($version, $branch) {
        if ($branch && $branch != 'dev') {
            if (strpos($version, 'beta') === false) {
                $branch = str_replace(['-', '_', '/'], '.', $branch);
                $version = $version.'-beta.'.$branch.'.0';
            }
        }
        $versionArr = explode('.', $version);
        $versionArr[count($versionArr) - 1]++;

        return implode('.', $versionArr);
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     * @throws Throwable
     */
    public function handle () {
        $dump_path = $this->option('dump_path');
        $base_namespace = $this->option('base_namespace');
        $this->dump_path = rtrim($dump_path ?: format_path('.'), '/').'/';
        $this->baseNamespace = $base_namespace ?: 'App\Rpc\Controllers\\';
        $build_version = $this->option('build-version');
        if ($build_version) {
            $config = file_get_contents($this->dump_path.(self::BASE_DIR_NAME.'/package.json'));
            $config = json_decode($config, true);
            $config['version'] = self::versionPlus($config['version'], $this->option('branch'));
            file_put_contents($this->dump_path.(self::BASE_DIR_NAME.'/package.json'), json_encode($config, JSON_PRETTY_PRINT));
            dump("new jssdk version {$config['version']}");
            return true;
        }
        $microName = studly_case(config('rpc-server.service_name', 'NoName'));

        if (file_exists($this->dump_path.(self::BASE_DIR_NAME."/source/micro/{$microName}"))) {
            del_file_tree($this->dump_path.(self::BASE_DIR_NAME."/source/micro/{$microName}"));
        }
        mkdir($this->dump_path.(self::BASE_DIR_NAME."/source/micro/{$microName}"), 0777, true);

        foreach (RpcRouterExtend::getRouterClassStruct($this->baseNamespace, true, false, true) as $className => $item) {
            $path = $this->dump_path.(RpcJsSdkDump::BASE_DIR_NAME."/source/micro/{$microName}/".str_replace('\\', '/', $item['namespace']));
            if (!is_dir($path)) {
                mkdir($path, 0777, true);
            }
            $this->comment(">>>> write /source/micro/{$microName}/{$item['namespace']}/{$item['shortName']}.js");

            $item['namespace'] = $item['namespace'] ? $microName.'\\'.$item['namespace'] : $microName;
            $filename = "$path/{$item['shortName']}.js";

            file_put_contents("$filename", view('js-sdk', [
                'microName'      => $microName,
                'className'      => $className,
                'shortClassName' => $item['shortName'],
                'methods'        => $item['methods'],
                'namespace'      => $this->baseNamespace.str_replace('/', '\\', $item['namespace']),
            ])->render());

            // 删除最后一个方法的逗号
            $content = file_get_contents($filename);
            $last = strrpos($content, ',');
            $new_content = substr($content, 0, $last);
            $new_content .= substr($content, $last + 1, strlen($content));
            file_put_contents($filename, $new_content);
        }
        return 0;
    }
}
