<?php

namespace Mainto\RpcTool\TestHelper;

use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;
use Mainto\RpcServer\Protocol\Common\Body;
use Mainto\RpcServer\Protocol\Common\Types\RequestHeaderType;
use Mainto\RpcServer\Protocol\Request\Extend\RequestExtendUrlInvoke;
use Mainto\RpcServer\Protocol\Request\Request;
use Mainto\RpcServer\RpcServer\RpcInvoke;
use Mainto\RpcServer\RpcServer\RpcRouter;
use RuntimeException;

trait ControllerDoc {
    use BuildDoc;

    /**
     * Dump IDE Start
     * ==========================================================
     */
    private array $methodsMap = [];
    /**
     * ===========================================================
     * Dump IDE End
     */

    /**
     * @param $class
     * @param $method
     * @param $params
     * @return mixed
     * @throws \Throwable
     */
    public function doInvoke ($class, $method, $params) {
        $request = new Request();
        $request->setType(RequestHeaderType::InvokeNormalType);
        $request->setCallClassAndMethod($class, $method);
        $request->setBody(Body::newJsonBody(json_encode($params)));

        $requestExtendUrlInvoke = new RequestExtendUrlInvoke();
        $requestExtendUrlInvoke->addHeader("X-Stream-Id", "unit_session_id");

        $request->setExtend($requestExtendUrlInvoke);

        return RpcInvoke::invokeBase($request);
    }

    /**
     * the controller class eg : ExampleController::class
     *
     * @return string
     */
    protected function getClass () { }

    /**
     * @return bool|string
     */
    protected function getClassCallName () {
        $alias = RpcRouter::getInstance()->getControllerAlias($this->getClass());
        if (substr($alias, -10, 10) == "Controller") {
            return substr($alias, 0, -10);
        } else {
            throw new RuntimeException('can not auto find class alias name, please implement me!');
        }
    }

    /**
     * @param $calledMethod
     * @param $params
     * @param bool $enable_doc
     * @return mixed
     * @throws ValidationException
     * @throws \Doctrine\Common\Annotations\AnnotationException
     * @throws \ReflectionException
     * @throws \Throwable
     */
    public function getResponse ($calledMethod, $params, $enable_doc = true) {
        $_temp_class = explode('\\', $this->getClass());
        if ($enable_doc) {
            $response = $this->dump(function () use ($calledMethod, $params, $_temp_class) {
                return $this->doInvoke($this->getClassCallName(), $calledMethod, $params);
            }, $this->getClass(), $calledMethod, $params);
        } else {
            return $this->doInvoke($this->getClassCallName(), $calledMethod, $params);
        }

        return $response;
    }

    /**
     * @param $name
     * @param $arguments
     * @return mixed
     * @throws \Throwable
     */
    public function __call ($name, $arguments) {
        if (strpos($name, 'call') === 0) {
            $method = Str::camel(substr($name, 4));
            if (method_exists($this->getClass(), $method)) {
                return $this->getResponse($method, ...$arguments);
            }
        }
        throw new \BadMethodCallException($name);
    }
}