<?php

if (!function_exists('var_export_min')) {
    /**
     * dump var
     *
     * @param $var
     * @param bool $return
     * @return mixed|string
     */
    function var_export_min ($var, $return = true) {
        if (is_array($var)) {
            $toImplode = [];
            foreach ($var as $key => $value) {
                $toImplode[] = var_export($key, true).' => '.var_export_min($value, true);
            }
            $code = '['.implode(',', $toImplode).']';
            if ($return) return $code;
            else echo $code;
        } else {
            return var_export($var, $return);
        }
    }
}

if (!function_exists('del_file_tree')) {
    /**
     * Delete file tree
     *
     * @param $dir
     * @return bool
     */
    function del_file_tree ($dir) {
        $files = array_diff(scandir($dir), ['.', '..']);
        foreach ($files as $file) {
            (is_dir("$dir/$file")) ? del_file_tree("$dir/$file") : unlink("$dir/$file");
        }
        return rmdir($dir);
    }
}

if (!function_exists('get_files')) {
    /**
     * Get files
     * @param $dir
     * @return array
     */
    function get_files ($dir) {
        $files = [];
        $scan = scandir($dir);
        foreach ($scan as $item) {
            if ($item == '.' || $item == '..') continue;
            if (is_dir($dir.'/'.$item)) {
                $files = array_merge($files, get_files($dir.'/'.$item));
            } else {
                $files[] = $dir.'/'.$item;
            }
        }
        return $files;
    }
}

if (!function_exists('get_git_branch_version')) {
    /**
     * Format the relative path as an absolute path with the current working directory as the reference
     *
     * @param string $base_path
     * @return string
     */
    function get_git_branch_version ($base_path = "") {
        if (!$version = env('CI_COMMIT_REF_SLUG')) {

            $git_file = $base_path ? $base_path.'/.git/HEAD' : base_path('/.git/HEAD');

            if (!file_exists($git_file)) {
                throw new \RuntimeException('get version fail');
            }

            $version = trim(str_replace(['ref: refs/heads/'], '', file_get_contents($git_file)));
            if (!$version) throw new \RuntimeException('get version fail');
        }
        return  $version;
    }
}

if (!function_exists('format_path')) {
    /**
     * Format the relative path as an absolute path with the current working directory as the reference
     *
     * @param $path
     * @return string
     */
    function format_path ($path) {
        if ($path[0] == ".") {
            $path = getcwd()."/{$path}";
        }

        $path = str_replace(['/', '\\'], DIRECTORY_SEPARATOR, $path);
        $parts = array_filter(explode(DIRECTORY_SEPARATOR, $path), 'strlen');
        $absolutes = [];
        foreach ($parts as $part) {
            if ('.' == $part) continue;
            if ('..' == $part) {
                array_pop($absolutes);
            } else {
                $absolutes[] = $part;
            }
        }
        return "/".implode(DIRECTORY_SEPARATOR, $absolutes);
    }
}

if (!function_exists('safe_url_string')) {
    /**
     * replace the str except [\w,-,.] to '-'
     *
     * @param string $str
     * @return string
     */
    function safe_url_string (string $str) {
        return preg_replace('/[^\w\-_.]/m', '-', $str);
    }
}