<?php
/**
 * Created by PhpStorm.
 * User: liuzaisen
 * Date: 2019/4/4
 * Time: 2:40 PM
 */

namespace Mainto\MRPCTool\TestHelper\Document;

use Illuminate\Contracts\Support\Arrayable;

/**
 * Class GroupApiRequestExample
 * @package Mainto\RpcServer\TestHelper\Document
 * @property array $request
 * @property array $response
 * @property string $name
 * @property string $comment
 */
class GroupApiRequestExample implements Arrayable, \ArrayAccess {
    /**
     * @param array $request
     */
    public function setRequest (array $request): void {
        $this->request = $request;
    }

    /**
     * @param array $response
     */
    public function setResponse (array $response): void {
        $this->response = $response;
    }

    /**
     * @param string $comment
     */
    public function setComment (string $comment): void {
        $this->comment = $comment;
    }

    /**
     * @var array
     */
    protected array $request;

    /**
     * @return array
     */
    public function getRequest (): array {
        return $this->request;
    }

    /**
     * @return array
     */
    public function getResponse (): array {
        return $this->response;
    }

    /**
     * @return string
     */
    public function getComment (): string {
        return $this->comment;
    }

    /**
     * @var array
     */
    protected array $response;

    /**
     * @var string
     */
    protected string $name;

    /**
     * @var string
     */
    protected string $comment;

    /**
     * Document constructor.
     * @param array $params
     */
    private function __construct ($params = []) {
        foreach ($params as $key => $value) {
            if (property_exists($this, $key)) {
                $this->{$key} = $value;
            }
        }
    }

    /**
     * @param $name
     * @param $request
     * @param $response
     * @param string $comment
     * @return GroupApiRequestExample
     */
    public static function newExample ($name, $request, $response, $comment = '') {
        return new self([
            'name'     => $name,
            'request'  => $request,
            'response' => $response,
            'comment'  => $comment,
        ]);
    }

    public function toArray () {
        return [
            'name'     => $this->name,
            'request'  => $this->request,
            'response' => $this->response,
            'comment'  => $this->comment,
        ];
    }

    /**
     * Whether a offset exists
     * @link  http://php.net/manual/en/arrayaccess.offsetexists.php
     * @param mixed $offset <p>
     *                      An offset to check for.
     *                      </p>
     * @return boolean true on success or false on failure.
     *                      </p>
     *                      <p>
     *                      The return value will be casted to boolean if non-boolean was returned.
     * @since 5.0.0
     */
    public function offsetExists ($offset) {
        return property_exists($this, $offset);
    }

    /**
     * Offset to retrieve
     * @link  http://php.net/manual/en/arrayaccess.offsetget.php
     * @param mixed $offset <p>
     *                      The offset to retrieve.
     *                      </p>
     * @return mixed Can return all value types.
     * @since 5.0.0
     */
    public function offsetGet ($offset) {
        if (property_exists($this, $offset)) {
            return $this->{$offset};
        }
    }

    /**
     * Offset to set
     * @link  http://php.net/manual/en/arrayaccess.offsetset.php
     * @param mixed $offset <p>
     *                      The offset to assign the value to.
     *                      </p>
     * @param mixed $value  <p>
     *                      The value to set.
     *                      </p>
     * @return void
     * @since 5.0.0
     */
    public function offsetSet ($offset, $value) {
        // TODO: Implement offsetSet() method.
    }

    /**
     * Offset to unset
     * @link  http://php.net/manual/en/arrayaccess.offsetunset.php
     * @param mixed $offset <p>
     *                      The offset to unset.
     *                      </p>
     * @return void
     * @since 5.0.0
     */
    public function offsetUnset ($offset) {
        // TODO: Implement offsetUnset() method.
    }
}