<?php
/**
 * Created by PhpStorm.
 * User: liuzaisen
 * Date: 2018/10/18
 * Time: 8:09 PM
 */

namespace Mainto\MRPCTool\Command;


use Exception;
use Illuminate\Console\Command;

class RpcDocClean extends Command {
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'rpc:doc_clean {--file_path=}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'clean document cache';

    /**
     * Execute the console command.
     *
     * @return mixed
     * @throws Exception
     */
    public function handle () {
        if (!$file_path = $this->option('file_path')) {
            $file_path = config('rpc-server.micro_doc.doc_dir').'/micro_document.json';
        }

        if (file_exists($file_path)) {
            if (unlink($file_path)) {
                $this->comment("clean success");
            } else {
                $this->comment("clean fail!");
                exit(1);
            }

            return;
        }

        $this->comment("no cache file need to clean");
        return;
    }

    /**
     * @param $file
     * @return string
     * @throws Exception
     */
    public function getNamespace ($file) {
        $fp = fopen($file, 'r');
        while ($line = fgets($fp)) {
            if (strpos($line, 'namespace') !== false) {
                fclose($fp);
                return trim(str_replace(['namespace', ';'], '', $line));
            }
        }
        fclose($fp);
        throw new Exception('not found namespace!');
    }
}