<?php

namespace Mainto\Mongodb;

use Jenssegers\Mongodb\Collection;
use Mainto\RpcServer\RpcUtil\JsonHelper;
use Mainto\RpcServer\Tracing\Interfaces\SpanKind;
use Mainto\RpcServer\Tracing\Span;
use Throwable;

class MongodbCollection extends Collection {
    /**
     * @param $method
     * @param $parameters
     * @return mixed
     * @throws Throwable
     */
    public function __call ($method, $parameters) {
        // span名称
        $spanName = sprintf('Mongodb Collection::%s', $method);
        // 链路
        $span = Span::start($spanName, null, SpanKind::KIND_CLIENT);
        try {
            if (!empty($parameters)) {
                $span->setAttribute('db.params', JsonHelper::encodeWithUnescapedAndError($parameters));
            }
            return parent::__call($method, $parameters);
        } catch (Throwable $e) {
            $span->statusError($e->getMessage());
            throw $e;
        } finally {
            $span->end();
        }
    }
}