<?php

namespace Mainto\Mongodb;

use Illuminate\Support\ServiceProvider;
use Jenssegers\Mongodb\Eloquent\Model;

/**
 * mongodb Trace 链路provider
 */
class MongodbTraceProvider extends ServiceProvider {
    /**
     * @return void
     */
    public function boot () {
        Model::setConnectionResolver($this->app['db']);
    }

    /**
     * @return void
     */
    public function register () {
        // Add database driver.
        $this->app->resolving('db', function ($db) {
            $db->extend('mongodb', function ($config, $name) {
                $config['name'] = $name;
                return new MongodbConnection($config);
            });
        });
    }
}