<?php

namespace Mainto\Mongodb;

use Closure;
use Jenssegers\Mongodb\Connection;
use Mainto\RpcServer\RpcUtil\JsonHelper;
use Mainto\RpcServer\Tracing\Context;
use Mainto\RpcServer\Tracing\Interfaces\SpanKind;
use Mainto\RpcServer\Tracing\Span;

class MongodbConnection extends Connection {
    /**
     * Get a MongoDB collection.
     * @param string $name
     * @return MongodbCollection
     */
    public function getCollection ($name) {
        return new MongodbCollection($this, $this->db->selectCollection($name));
    }

    /**
     * @param $query
     * @param $bindings
     * @param Closure $callback
     * @return mixed
     */
    public function run ($query, $bindings, Closure $callback) {
        $span = Span::start('Mongodb Connection::run', null, SpanKind::KIND_CLIENT);
        try {
            $span->setAttribute('db.sql', $query);
            // 判断是否为空，不为空则记录
            if (!empty($bindings)) {
                $span->setAttribute('db.bindings', JsonHelper::encodeWithUnescapedAndError($bindings));
            }
            return parent::run($query, $bindings, $callback);
        } finally {
            $span->end();
        }
    }

    /**
     * @param $query
     * @param $bindings
     * @param $time
     * @return void
     */
    public function logQuery ($query, $bindings, $time = null) {
        if ($span = Context::currentSpan()) {
            $span->setAttribute('db.query', $query);
            $span->setAttribute('db.time', strval($time));
        }
        parent::logQuery($query, $bindings, $time);
    }
}
