<?php

namespace Mainto\Mongodb\Traits;

use Illuminate\Support\Collection;
use MongoDB\BSON\ObjectId;
use MongoDB\BSON\UTCDateTime;
use MongoDB\Model\BSONDocument;

trait MongoTransTrait {
    public function castMultiToArray (?array $arr): ?array {
        if (is_null($arr)) return null;

        return $this->castMultiCollection(collect($arr))->all();
    }

    public function castMultiCollection (?Collection $collection): ?Collection {
        if (is_null($collection)) return null;

        return $collection->map(function ($obj) {
            if (is_array($obj)) {
                return $this->castMongoDocumentArrayToArray($obj);
            } elseif ($obj instanceof BSONDocument) {
                return $this->castMongoDocumentToArray($obj);
            } else {
                return $this->castMongoItem($obj);
            }
        });
    }

    protected function castMongoDocumentArrayToArray (?array $document): array {
        return collect($document)
            ->map(function ($obj) {
                return $this->castMongoItem($obj);
            })
            ->all();
    }

    protected function castMongoItem ($obj) {
        static $timeZone;
        if (!$timeZone) $timeZone = now()->timezone;

        if ($obj instanceof UTCDateTime) {
            return $obj->toDateTime()->setTimezone($timeZone)->format("Y-m-d H:i:s");
        } elseif ($obj instanceof ObjectId) {
            return strval($obj);
        } else {
            return $obj;
        }
    }

    protected function castMongoDocumentToArray (?BSONDocument $document): ?array {
        if (is_null($document)) return null;

        return $this->castMongoDocumentArrayToArray($document->getArrayCopy());
    }
}
