<?php
namespace Mainto\Mongodb;

use Mainto\RpcServer\RpcUtil\JsonHelper;
use Mainto\RpcServer\Tracing\Span;
use Throwable;

/**
 * @mixin Mongodb
 */
class CollectionRepository {
    /**
     * @var Mongodb
     */
    protected Mongodb $mongodb;

    /**
     * 实例化对象
     */
    public function __construct() {
        $this->mongodb = new Mongodb();
    }

    /**
     * @param string $method
     * @param array $args
     *
     * @return false|mixed
     * @throws Throwable
     */
    public function __call (string $method, array $args) {
        $spanName = sprintf('Mongodb Repository::%s', $method);
        $span = Span::start($spanName);
        try {
            $span->setAttribute('mongodb.params', JsonHelper::encodeWithUnescapedAndError($args));
            return call_user_func_array([$this->mongodb, $method], $args);
        } catch (Throwable $e) {
            $span->statusError($e->getMessage());
            throw $e;
        } finally {
            $span->end();
        }
    }
}
