<?php

namespace Mainto\Mongodb;

use Closure;
use Jenssegers\Mongodb\Connection;
use Mainto\RpcServer\RpcUtil\JsonHelper;
use Mainto\RpcServer\Tracing\Interfaces\SpanKind;
use Mainto\RpcServer\Tracing\Span;

class MongodbConnection extends Connection {
    public function run ($query, $bindings, Closure $callback) {
        $span = Span::start('Mongodb Executed', null, SpanKind::KIND_CLIENT);
        try {
            $span->setAttribute('db.sql', $query);
            // 判断是否为空，不为空则记录
            if (!empty($bindings)) {
                $span->setAttribute('db.bindings', JsonHelper::encodeWithUnescapedAndError($bindings));
            }
            return parent::run($query, $bindings, $callback);
        } finally {
            $span->end();
        }
    }
}
