<?php
namespace Mainto\Bridge\Mock\User;

use Mainto\RpcServer\Exceptions\RpcRuntimeException;
use Mainto\RpcServer\RpcClient\RpcMockClass;

class MockProvider {
    /**
     * MockProvider constructor.
     *
     * @param  RpcMockClass $mockClass
     * @param  string $serviceName
     * @param  string $className
     */
    public function __construct (RpcMockClass $mockClass, string $serviceName, string $className) {
        $dataPath = __DIR__."/data/".str_replace("\\", "/", $className);
        if (file_exists($dataPath)) {
            $this->scandir($dataPath, $mockClass);
        }
    }

    /**
    * @param  string $dir
    * @param  RpcMockClass $mockClass
    */
    private function scandir (string $dir, RpcMockClass $mockClass): void {
        foreach (array_diff(scandir($dir), ['..', '.']) as $file) {
            $path = $dir."/".$file;
            if (is_dir($path)) {
                continue;
            }
            $jsonContent = json_decode(file_get_contents($path), true);
            $methodName = substr($file, 0, -5);
            foreach ($jsonContent as $requestId => $responseData) {
                $mockClass->setCallbackMock($methodName, $this->genCallbackMock($responseData), $requestId);
            }
        }
    }

    private function genCallbackMock ($responseData): \Closure {
        return function ($args = []) use ($responseData) {
            if (!isset($responseData['success'])) {
                throw new RpcRuntimeException("response data is invalid!");
            }

            if ($responseData['success']) {
                return $responseData['msg'];
            } else {
                throw new RpcRuntimeException($responseData['error_msg'] ?? 'unknown', $responseData['error_code'] ?? 500);
            }
        };
    }
}