<?php
namespace Mainto\Bridge\Mock\Test;

use Mainto\RpcServer\RpcClient\RpcMockClass;

class MockProvider {
    /**
     * MockProvider constructor.
     *
     * @param  RpcMockClass $mockClass
     * @param  string $serviceName
     * @param  string $className
     */
    public function __construct (RpcMockClass $mockClass, string $serviceName, string $className) {
        $dataPath = __DIR__."/data/".str_replace("\\", "/", $className);

        foreach (array_diff(scandir($dataPath), ['..', '.']) as $file) {
            $jsonContent = json_decode(file_get_contents($dataPath."/".$file), true);
            $methodName = substr($file, 0, -5);

            foreach ($jsonContent as $requestId => $responseData) {
                $mockClass->setValueMock($methodName, $responseData, $requestId);
            }
        }
    }
}