<?php

namespace Mainto\DMP;

use Mainto\DMP\Cmd\GroupInfoCmd;
use Mainto\DMP\Cmd\GroupListCmd;
use Mainto\DMP\Cmd\GroupUserListCMD;
use Mainto\DMP\Cmd\UserGroupListCmd;
use Mainto\DMP\Config\DmpConfig;
use Mainto\RpcServer\Exceptions\RpcRuntimeException;

class Service {

    public static function sendUserGroupList (UserGroupListCmd $UserGroupListCmd): array {
        if (empty($UserGroupListCmd)) {
            throw new RpcRuntimeException('UserGroupListCmd not empty');
        }
        return guzzleGet(DMPConfig::VERSION_MAP[$UserGroupListCmd->version].DmpConfig::DMP_USER_GROUP_LIST, objectToArray($UserGroupListCmd));
    }

    public static function sendGroupList (GroupListCmd $GroupListCmd): array {
        if (empty($GroupListCmd)) {
            throw new RpcRuntimeException('GroupListCmd not empty');
        }
        return guzzlePost(DMPConfig::VERSION_MAP[$GroupListCmd->version].DmpConfig::DMP_GROUP_LIST, objectToArray($GroupListCmd));
    }

    public static function sendGroupInfo (GroupInfoCmd $GroupInfoCmd): array {
        if (empty($GroupInfoCmd)) {
            throw new RpcRuntimeException('GroupInfoCmd not empty');
        }
        return guzzlePost(DMPConfig::VERSION_MAP[$GroupInfoCmd->version].DmpConfig::DMP_GROUP_INFO, $GroupInfoCmd->groupIdList);
    }

    public static function sendGroupUserList (GroupUserListCmd $GroupUserListCmd): array {
        if (empty($GroupUserListCmd)) {
            throw new RpcRuntimeException('GroupUserListCmd not empty');
        }
        return guzzlePost(DMPConfig::VERSION_MAP[$GroupUserListCmd->version].DmpConfig::DMP_GROUP_USER_LIST, objectToArray($GroupUserListCmd));
    }

}