<?php

use GuzzleHttp\Client;
use GuzzleHttp\Exception\GuzzleException;
use Mainto\DMP\Config\DmpConfig;
use Mainto\RpcServer\RpcUtil\Tool\RpcLog;

if (!function_exists('guzzlePost')) {
    function guzzlePost (string $url, array $data): array {
        try {
            $client = new Client([
                'headers' => ['Content-Type' => 'application/json'],
            ]);
            $response = $client->request('POST', $url, [
                'body' => json_encode(array_merge($data, ['timeout' => DmpConfig::TIME_OUT]), JSON_UNESCAPED_SLASHES),
            ]);
            $result = json_decode($response->getBody()->getContents(), JSON_UNESCAPED_SLASHES);
            if ($result["success"] === true) {
                return $result['msg'];
            }
            return [];
        } catch (GuzzleException $e) {
            // 错误全部上传日志
            RpcLog::getInstance()->error('dmp.client.error', [
                'msg' => $e->getMessage(),
            ]);
            return [];
        }
    }
}

if (!function_exists('guzzleGet')) {
    function guzzleGet (string $url, array $data): array {
        try {
            $client = new Client();
            $response = $client->request('GET', $url, array_merge(["query" => $data], ['timeout' => DmpConfig::TIME_OUT]));
            $result = json_decode($response->getBody()->getContents(), JSON_UNESCAPED_SLASHES);
            if ($result["success"] === true) {
                return $result['msg'];
            }
            return [];
        } catch (GuzzleException $e) {
            RpcLog::getInstance()->error('dmp.client.error', [
                'msg' => $e->getMessage(),
            ]);
            return [];
        }
    }
}


if (!function_exists('objectToArray')) {
    function objectToArray ($array) {
        if (is_object($array)) {
            $array = (array)$array;
        }
        if (is_array($array)) {
            foreach ($array as $key => $value) {
                $array[$key] = objectToArray($value);
            }
        }
        return $array;
    }
}
