<?php

namespace Mainto\DMP;

use Mainto\DMP\Cmd\GroupInfoCmd;
use Mainto\DMP\Cmd\GroupListCmd;
use Mainto\DMP\Cmd\GroupUserListCMD;
use Mainto\DMP\Cmd\UserGroupListCmd;
use Mainto\DMP\DTO\UserListDTO;
use Mainto\DMP\Translator\IndexTranslator;
use Mainto\RpcServer\Tracing\Extend\TraceAOP;

class DmpService extends TraceAOP {

    /**
     * 用户所在人群
     *
     * @param UserGroupListCmd $UserGroupListCmd
     * @return array
     */
    public function sendUserGroupList (UserGroupListCmd $UserGroupListCmd): array {
        return Service::sendUserGroupList($UserGroupListCmd);
    }

    /**
     * 人群用户列表
     *
     * @param GroupUserListCMD $userListCMD
     * @return UserListDTO
     */
    public function sendGroupUserList (GroupUserListCMD $userListCMD): UserListDTO {
        return IndexTranslator::toUserList(Service::sendGroupUserList($userListCMD));
    }

    /**
     * 人群列表
     *
     * @param GroupListCmd $GroupListCmd
     * @return array
     */
    public function sendGroupList (GroupListCmd $GroupListCmd): array {
        return Service::sendGroupList($GroupListCmd);
    }

    /**
     * 用户所在人群信息
     *
     * @param GroupInfoCmd $GroupInfoCmd
     * @return array
     */
    public function sendGroupInfo (GroupInfoCmd $GroupInfoCmd): array {
        return Service::sendGroupInfo($GroupInfoCmd);
    }

}