<?php
namespace Mainto\Bridge\Invokes\WorkOrder\WorkOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\IssueListCmd $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateWorkOrderIssueCmd $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\UpdateWorkOrderIssueCmd $params)
 * @method deleteByParams(array $params)
 * @method detailByParams(array $params)
 * @method categoriesByParams(array $params)
 * @method issueCategoryDeleteByParams(array $params)
 * @method issueCategoryUpdateByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\IssueCategoryCmd $params)
 */
class WorkOrderIssue {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * list
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\IssueListCmd $issueListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\IssueListDTO
     */
    public static function list (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\IssueListCmd $issueListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($issueListCmd),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\IssueListDTO"
        );
    }


    /**
     * create
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateWorkOrderIssueCmd $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function create (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateWorkOrderIssueCmd $cmd) {
        return self::getClass()->create($cmd);
    }


    /**
     * update
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\UpdateWorkOrderIssueCmd $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function update (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\UpdateWorkOrderIssueCmd $cmd) {
        return self::getClass()->update($cmd);
    }


    /**
     * delete
     *
     * @param  int $issueId 问题 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $issueId) {
        return self::getClass()->delete([
            "issueId" => $issueId,
        ]);
    }

    /**
     * detail
     *
     * @param  int $issueId 问题 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderIssueDTO
     */
    public static function detail (int $issueId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail([
                            "issueId" => $issueId,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderIssueDTO"
        );
    }

    /**
     * categories
     *
     * @param  string $categoryName 目录 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\RpcServer\Util\Types\Map<string>
     */
    public static function categories (string $categoryName = '') {
        return self::getClass()->categories([
            "categoryName" => $categoryName,
        ]);
    }

    /**
     * issueCategoryDelete
     *
     * @param  int $issueCategoryId 分类id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function issueCategoryDelete (int $issueCategoryId) {
        return self::getClass()->issueCategoryDelete([
            "issueCategoryId" => $issueCategoryId,
        ]);
    }

    /**
     * issueCategoryUpdate
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\IssueCategoryCmd $issueCategoryCmd
     * @throws  \Exception
     * @return  int
     */
    public static function issueCategoryUpdate (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\IssueCategoryCmd $issueCategoryCmd) {
        return self::getClass()->issueCategoryUpdate($issueCategoryCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('WorkOrder', 'WorkOrder\WorkOrderIssue');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('WorkOrder', 'WorkOrder\WorkOrderIssue');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}