<?php
namespace Mainto\Bridge\Invokes\WorkOrder\WorkOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByAdminByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateByAdminCmd $params)
 * @method deleteByParams(array $params)
 * @method processByParams(array $params)
 * @method finishByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\FinishCmd $params)
 * @method updateCategoryByParams(array $params)
 * @method createCodingByParams(array $params)
 * @method bindCodingByParams(array $params)
 * @method resetDeletedCodingByParams(array $params)
 * @method removeCodingRelationByParams(array $params)
 */
class Manage {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * createByAdmin
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateByAdminCmd $command
     * @throws  \Exception
     * @return  int
     */
    public static function createByAdmin (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateByAdminCmd $command) {
        return self::getClass()->createByAdmin($command);
    }


    /**
     * delete
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $workOrderId, int $operator) {
        return self::getClass()->delete([
            "workOrderId" => $workOrderId,
            "operator" => $operator,
        ]);
    }

    /**
     * process
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function process (int $workOrderId, int $operator) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->process([
                            "workOrderId" => $workOrderId,
                            "operator" => $operator,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }

    /**
     * finish
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\FinishCmd $command
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function finish (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\FinishCmd $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->finish($command),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }


    /**
     * updateCategory
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  string $category 分类 [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function updateCategory (int $workOrderId, string $category, int $operator) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->updateCategory([
                            "workOrderId" => $workOrderId,
                            "category" => $category,
                            "operator" => $operator,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }

    /**
     * createCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function createCoding ($context, int $workOrderId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->createCoding([
                            "context" => $context,
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }

    /**
     * bindCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $codingId codingId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function bindCoding (int $workOrderId, int $codingId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->bindCoding([
                            "workOrderId" => $workOrderId,
                            "codingId" => $codingId,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }

    /**
     * resetDeletedCoding
     *
     * @support  string $createdAtStart 创建时间-起 [ require false ]
     * @support  string $createdAtEnd 创建时间-止 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetDeletedCoding ($context) {
        return self::getClass()->resetDeletedCoding([
            "context" => $context,
        ]);
    }

    /**
     * removeCodingRelation
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $operator operator [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function removeCodingRelation (int $workOrderId, int $operator) {
        return self::getClass()->removeCodingRelation([
            "workOrderId" => $workOrderId,
            "operator" => $operator,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('WorkOrder', 'WorkOrder\Manage');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('WorkOrder', 'WorkOrder\Manage');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}