<?php
namespace Mainto\Bridge\Invokes\WorkOrder\WorkOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateCmd $params)
 * @method countByParams(array $params)
 * @method getUploadTokenByParams(array $params)
 * @method detailByParams(array $params)
 * @method reporterCountByParams(array $params)
 * @method notFinishedCountByParams(array $params)
 * @method bugCountByParams(array $params)
 * @method codingInfoByParams(array $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\ListCmd $params)
 * @method locationToCodingByParams(array $params)
 * @method categoriesCountByParams(array $params)
 * @method categoriesCountByDateByParams(array $params)
 * @method getAllowRelationCodingByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * create
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateCmd $cmd
     * @throws  \Exception
     * @return  int
     */
    public static function create (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\CreateCmd $cmd) {
        return self::getClass()->create($cmd);
    }


    /**
     * count
     *
     * @throws  \Exception
     * @return  int
     */
    public static function count () {
        return self::getClass()->count();
    }

    /**
     * 获取上传签名
     *
     * @throws  \Exception
     * @return  string
     */
    public static function getUploadToken () {
        return self::getClass()->getUploadToken();
    }

    /**
     * detail
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO
     */
    public static function detail (int $workOrderId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->detail([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\WorkOrderDTO"
        );
    }

    /**
     * reporterCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function reporterCount () {
        return self::getClass()->reporterCount();
    }

    /**
     * notFinishedCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function notFinishedCount () {
        return self::getClass()->notFinishedCount();
    }

    /**
     * bugCount
     *
     * @throws  \Exception
     * @return  int
     */
    public static function bugCount () {
        return self::getClass()->bugCount();
    }

    /**
     * codingInfo
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CodingInfoDTO
     */
    public static function codingInfo (int $workOrderId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->codingInfo([
                            "workOrderId" => $workOrderId,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CodingInfoDTO"
        );
    }

    /**
     * list
     *
     * @var  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\ListCmd $command
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\ListDTO
     */
    public static function list (\Mainto\Bridge\Structs\WorkOrder\WorkOrder\Cmd\ListCmd $command) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->list($command),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\ListDTO"
        );
    }


    /**
     * locationToCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function locationToCoding ($context, int $workOrderId) {
        return self::getClass()->locationToCoding([
            "context" => $context,
            "workOrderId" => $workOrderId,
        ]);
    }

    /**
     * categoriesCount
     *
     * @support  string $createdAtStart 创建时间-起 [ require false ]
     * @support  string $createdAtEnd 创建时间-止 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\RpcServer\Util\Types\Map<\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CategoryCountDTO>
     */
    public static function categoriesCount ($context) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->categoriesCount([
                            "context" => $context,
                        ]),
            "\Mainto\RpcServer\Util\Types\Map<\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CategoryCountDTO>"
        );
    }

    /**
     * categoriesCountByDate
     *
     * @support  string $createdAtStart 创建时间-起 [ require false ]
     * @support  string $createdAtEnd 创建时间-止 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CategoryCountByDateDTO[]
     */
    public static function categoriesCountByDate ($context) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->categoriesCountByDate([
                            "context" => $context,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CategoryCountByDateDTO[]"
        );
    }

    /**
     * getAllowRelationCoding
     *
     * @param  int $workOrderId 工单ID [ require true ]
     * @param  int $codingId codingId [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CodingInfoDTO
     */
    public static function getAllowRelationCoding (int $workOrderId, int $codingId) {
        return RpcDefinition::getInstance()->getMapper()->mapUseTypeString(
            self::getClass()->getAllowRelationCoding([
                            "workOrderId" => $workOrderId,
                            "codingId" => $codingId,
                        ]),
            "\Mainto\Bridge\Structs\WorkOrder\WorkOrder\DTO\CodingInfoDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('WorkOrder', 'WorkOrder\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('WorkOrder', 'WorkOrder\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}